/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.move_to_screw;

import com.spin.util.api.ExtendedProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.Pose;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToScrewData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final UndoRedoManager undoRedoManager;

    MoveToScrewData(@NotNull DataModel dataModel, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
    }

    boolean isValidConfiguration() {
        return this.getPose() != null;
    }

    boolean reverseDirection() {
        return this.dataModel.get("reverseDirection", false);
    }

    void setReverseDirection(boolean reverseDirection) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("reverseDirection", reverseDirection));
    }

    boolean ignoreSafetyShield() {
        return this.dataModel.get("ignoreSafetyShield", false);
    }

    void setIgnoreSafetyShield(boolean ignoreSafetyShield) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("ignoreSafetyShield", ignoreSafetyShield));
    }

    boolean approachEnabled() {
        return this.dataModel.get("approachEnabled", true);
    }

    void setApproachEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("approachEnabled", enabled));
    }

    @Nullable
    Pose getPose() {
        return this.dataModel.get("pose", (Pose)null);
    }

    void setPose(@NotNull Pose pose) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("pose", pose));
    }
}

