/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.inputfield;

import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Torque;
import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnitRenderer<Unit>
implements InputField.Renderer<Unit> {
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final DecimalFormat decimalFormat;

    public UnitRenderer(@NotNull UnitConverter unitConverter, @NotNull DecimalFormat decimalFormat) {
        this.unitConverter = unitConverter;
        this.decimalFormat = decimalFormat;
    }

    @Override
    @Nullable
    public String textFrom(@Nullable Unit value) {
        if (value == null) {
            return null;
        }
        Class<Unit> clazz = this.classOf(value);
        return this.decimalFormat.format(this.unitConverter.valueOf(clazz, value));
    }

    @NotNull
    private Class<Unit> classOf(@NotNull Unit value) {
        if (value instanceof Length) {
            return Length.class;
        }
        if (value instanceof Force) {
            return Force.class;
        }
        if (value instanceof Mass) {
            return Mass.class;
        }
        if (value instanceof Speed) {
            return Speed.class;
        }
        if (value instanceof Torque) {
            return Torque.class;
        }
        throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
    }
}

