/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReadPOM {
    public static Map<String, String> parseProjectToMap(String pomPath) {
        try {
            InputStream inputStream = ReadPOM.class.getClassLoader().getResourceAsStream(pomPath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("project");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                NodeList childNodes = eElement.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    if (childNode.getNodeType() != 1) continue;
                    Element childElement = (Element)childNode;
                    map.put(childElement.getTagName(), childElement.getTextContent());
                }
            }
            return map;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static Map<String, String> parsePropertiesToMap(String pomPath) {
        try {
            InputStream inputStream = ReadPOM.class.getClassLoader().getResourceAsStream(pomPath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("project");
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                NodeList childNodes = eElement.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Element childElement;
                    Node childNode = childNodes.item(i);
                    if (childNode.getNodeType() != 1 || !"properties".equals((childElement = (Element)childNode).getTagName())) continue;
                    NodeList propertyNodes = childElement.getChildNodes();
                    for (int j = 0; j < propertyNodes.getLength(); ++j) {
                        Node propertyNode = propertyNodes.item(j);
                        if (propertyNode.getNodeType() != 1) continue;
                        Element propertyElement = (Element)propertyNode;
                        String propertyName = propertyElement.getTagName();
                        String propertyValue = propertyElement.getTextContent();
                        propertiesMap.put(propertyName, propertyValue);
                    }
                }
            }
            return propertiesMap;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

