/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.program_data;

import com.spin.bridge_communication.program_data.ProgramDataConsumer;
import com.spin.bridge_communication.program_data.ProgramDataProvider;
import com.spin.domain.Group;
import com.spin.domain.Program;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProgramDataDispatcher
implements ProgramDataProvider,
ProgramDataConsumer {
    @NotNull
    private final Collection<ProgramDataConsumer> consumers = new HashSet<ProgramDataConsumer>();
    @NotNull
    private Set<Program> programs = new HashSet<Program>();
    @NotNull
    private Set<Group> groups = new HashSet<Group>();

    @Override
    @NotNull
    public synchronized Set<Program> getPrograms() {
        return this.programs;
    }

    @Override
    @NotNull
    public synchronized Set<Group> getGroups() {
        return this.groups;
    }

    @Override
    public void unregisterConsumer(@NotNull ProgramDataConsumer consumer) {
        this.consumers.remove(consumer);
    }

    @Override
    public void registerConsumer(@NotNull ProgramDataConsumer consumer) {
        this.consumers.add(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull Set<Program> programs, @NotNull Set<Group> groups) {
        ProgramDataDispatcher programDataDispatcher = this;
        synchronized (programDataDispatcher) {
            this.programs = programs;
            this.groups = groups;
        }
        this.forwardToConsumers(programs, groups);
    }

    private void forwardToConsumers(@NotNull Set<Program> programs, @NotNull Set<Group> groups) {
        for (ProgramDataConsumer consumer : this.consumers) {
            consumer.process(programs, groups);
        }
    }
}

