/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.unload_screw;

import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.unload_screw.UnloadScrewData;
import com.spin.core.program_node.unload_screw.UnloadScrewScriptGenerator;
import com.spin.core.program_node.unload_screw.UnloadScrewText;
import com.spin.core.program_node.unload_screw.UnloadScrewView;
import com.spin.domain.MultiInstall;
import com.spin.domain.ScrewFeeder;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnloadScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final UnloadScrewView view;
    @NotNull
    private final UnloadScrewData data;
    @NotNull
    private final UnloadScrewScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final InstallationContribution installationContribution;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final PoseFactory poseFactory;

    UnloadScrewContribution(@NotNull UnloadScrewView unloadScrewView, @NotNull UnloadScrewData data, @NotNull UnloadScrewScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = unloadScrewView;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.poseFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getPoseFactory();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
    }

    public void openView() {
        this.view.setScrewFeeders(this.installationContribution.getScrewFeeders());
        this.view.selectedScrewFeeder(this.data.selectedScrewFeeder());
        this.view.setApproachEnabled(this.data.approachEnabled());
        this.view.setDepartEnabled(this.data.departEnabled());
        if (this.data.getPose() == null) {
            this.view.setButtonStyleAsTeach();
            this.view.verifyPositionButtonEnabled(false);
        } else {
            this.view.setButtonStyleAsReTeach();
            this.view.verifyPositionButtonEnabled(true);
        }
    }

    public void closeView() {
    }

    @NotNull
    public String getTitle() {
        return MultiInstall.prefix() + this.textResource.load(UnloadScrewText.UNLOAD_SCREW);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    void onExitVerifyPosition() {
        this.view.toggleActivePanel();
    }

    void selectScrewFeeder(@NotNull ScrewFeeder screwFeeder) {
        this.data.setSelectedScrewFeeder(screwFeeder);
    }

    void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    void setDepartEnabled(boolean enabled) {
        this.data.setDepartEnabled(enabled);
    }

    @NotNull
    UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    void setPose(@NotNull Pose pose) {
        this.data.setPose(pose);
    }

    @NotNull
    Pose poseAbove() {
        Pose pose = Objects.requireNonNull(this.data.getPose());
        Position pos = pose.getPosition();
        Rotation rot = pose.getRotation();
        return this.poseFactory.createPose(pos.getX(Length.Unit.MM), pos.getY(Length.Unit.MM), pos.getZ(Length.Unit.MM) + 50.0, rot.getRX(Angle.Unit.DEG), rot.getRY(Angle.Unit.DEG), rot.getRZ(Angle.Unit.DEG), Length.Unit.MM, Angle.Unit.DEG);
    }

    @Nullable
    Pose pose() {
        return this.data.getPose();
    }
}

