/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup_slave;

import com.spin.core.program_node.screwdriving_setup_slave.ScrewdrivingSetupContribution;
import com.spin.core.program_node.screwdriving_setup_slave.ScrewdrivingSetupText;
import com.spin.domain.Group;
import com.spin.domain.Program;
import com.spin.ui.callback.OnOkPositionCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrewdrivingSetupView
implements SwingProgramNodeView<ScrewdrivingSetupContribution> {
    @NotNull
    private final ImagePanel teachScrewImg;
    @NotNull
    private final ComboBox<Group> groupSelector = new ComboBox();
    @NotNull
    private final ComboBox<Program> programSelector = new ComboBox();
    @NotNull
    private final Label notConnectedWarningLabel;
    @NotNull
    private final Label noPartsWarningLabel;
    @NotNull
    private final Label noProgramsWarningLabel;
    @NotNull
    private final ButtonMedium teachPositionButton;
    @NotNull
    private final String teachPositionText;
    @NotNull
    private final String reteachPositionText;
    @NotNull
    private final ButtonMedium verifyPositionButton;
    @NotNull
    private final CheckBox spinTargetCheckBox;
    @Nullable
    private Group selectedGroup = null;
    @Nullable
    private Program selectedProgram = null;

    ScrewdrivingSetupView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        this.groupSelector.setDefaultText(textResource.load(ScrewdrivingSetupText.NO_PART_SELECTED));
        this.programSelector.setDefaultText(textResource.load(ScrewdrivingSetupText.NO_PROGRAM_SELECTED));
        this.teachScrewImg = new ImagePanel(SpinImage.TEACH_SCREW_GOOD_BAD.load(new Dimension(200, -1)));
        ImageIcon warningIcon = UR_Icon.WARNING_SMALL.load();
        this.notConnectedWarningLabel = new Label(textResource.load(ScrewdrivingSetupText.NOT_CONNECTED));
        this.noPartsWarningLabel = new Label(textResource.load(ScrewdrivingSetupText.NO_PARTS_AVAILABLE));
        this.noProgramsWarningLabel = new Label(textResource.load(ScrewdrivingSetupText.NO_PROGRAMS_AVAILABLE));
        this.notConnectedWarningLabel.setIcon(warningIcon);
        this.noPartsWarningLabel.setIcon(warningIcon);
        this.noProgramsWarningLabel.setIcon(warningIcon);
        this.teachPositionText = textResource.load(ScrewdrivingSetupText.TEACH_SCREW_POSITION);
        this.reteachPositionText = textResource.load(ScrewdrivingSetupText.RETEACH_SCREW_POSITION);
        this.teachPositionButton = new ButtonMedium(this.reteachPositionText, UR_Icon.MOVE_TEACH.load());
        this.verifyPositionButton = new ButtonMedium(textResource.load(ScrewdrivingSetupText.VERIFY_SCREW_POSITION), UR_Icon.MOVE.load());
        this.spinTargetCheckBox = new CheckBox(textResource.load(ScrewdrivingSetupText.SPIN_TARGET_ENABLE));
    }

    public void buildUI(@NotNull JPanel panel, @NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][]0[]0[]0[]push[][][]push[]"));
        ImagePanel logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        panel.add(this.groupSelector, "cell 0 0, span 7, growx");
        panel.add(this.programSelector, "cell 0 1, span 7, growx");
        panel.add((Component)this.notConnectedWarningLabel, "cell 0 2, span 7, gaptop 10, growx, hidemode 3");
        panel.add((Component)this.noPartsWarningLabel, "cell 0 3, span 7, gaptop 10, growx, hidemode 3");
        panel.add((Component)this.noProgramsWarningLabel, "cell 0 4, span 7, gaptop 10, growx, hidemode 3");
        panel.add((Component)this.teachPositionButton, "cell 1 5, span 5, grow");
        panel.add((Component)this.verifyPositionButton, "cell 1 6, span 5, grow");
        panel.add((Component)this.spinTargetCheckBox, "cell 1 7, span 4");
        panel.add((Component)this.teachScrewImg, "cell 7 3, span 5 6, grow");
        panel.add((Component)logo, "cell 0 8, span 4, left");
        this.registerListeners(provider);
    }

    private void registerListeners(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        this.groupSelector.addActionListener(event -> this.reactToGroupSelection(provider));
        this.programSelector.addActionListener(event -> this.reactToProgramSelection(provider));
        this.teachPositionButton.addActionListener(event -> this.reactToTeachButtonClicked(provider));
        this.verifyPositionButton.addActionListener(event -> this.moveToScrew(provider));
        this.spinTargetCheckBox.addActionListener(event -> this.reactToSpinTargetCheckBox(provider));
    }

    void setGroups(@NotNull Collection<Group> parts) {
        this.groupSelector.runWithoutFiringActionsEvents(() -> {
            this.groupSelector.removeAllItems();
            parts.stream().sorted(Comparator.comparing(part -> part.name().toLowerCase()).thenComparing(Group::name)).forEach(this.groupSelector::addItem);
            this.groupSelector.addItem(null);
            this.selectedGroup = (Group)this.groupSelector.getSelectedItem();
        });
    }

    void setPrograms(@NotNull Collection<Program> programs) {
        this.programSelector.runWithoutFiringActionsEvents(() -> {
            this.programSelector.removeAllItems();
            programs.stream().sorted(Comparator.comparing(program -> program.name().toLowerCase()).thenComparing(Program::name)).forEach(this.programSelector::addItem);
        });
        this.selectedProgram = (Program)this.programSelector.getSelectedItem();
    }

    void selectPart(@Nullable Group part) {
        this.groupSelector.runWithoutFiringActionsEvents(() -> this.groupSelector.setSelectedItem(part));
        this.selectedGroup = part;
    }

    void selectProgram(@Nullable Program program) {
        this.programSelector.runWithoutFiringActionsEvents(() -> this.programSelector.setSelectedItem(program));
        this.selectedProgram = program;
    }

    void enablePartSelector(boolean enable) {
        this.groupSelector.setEnabled(enable);
    }

    void enableProgramSelector(boolean enable) {
        this.programSelector.setEnabled(enable);
    }

    void setNotConnectedWarningVisible(boolean visible) {
        this.notConnectedWarningLabel.setVisible(visible);
    }

    void setNoPartsWarningVisible(boolean visible) {
        this.noPartsWarningLabel.setVisible(visible);
    }

    void setNoProgramsWarningVisible(boolean visible) {
        this.noProgramsWarningLabel.setVisible(visible);
    }

    void setSpinTargetEnabled(boolean enabled) {
        this.spinTargetCheckBox.setSelected(enabled);
    }

    void setButtonStyleAsTeach() {
        this.teachPositionButton.enableCallToActionStyle(true);
        this.teachPositionButton.setText(this.teachPositionText);
    }

    void setButtonStyleAsReteach() {
        this.teachPositionButton.enableCallToActionStyle(false);
        this.teachPositionButton.setText(this.reteachPositionText);
    }

    void enableVerifyPositionButton(boolean enable) {
        this.verifyPositionButton.setEnabled(enable);
    }

    void enableButtons(boolean enable) {
        this.teachPositionButton.setEnabled(enable);
    }

    private void reactToGroupSelection(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        Group oldSelection = this.selectedGroup;
        this.selectedGroup = (Group)this.groupSelector.getSelectedItem();
        if (this.selectedGroup == oldSelection) {
            return;
        }
        ((ScrewdrivingSetupContribution)provider.get()).setSelectedGroup(this.selectedGroup);
    }

    private void reactToProgramSelection(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        Program oldSelection = this.selectedProgram;
        this.selectedProgram = (Program)this.programSelector.getSelectedItem();
        if (this.selectedProgram == oldSelection) {
            return;
        }
        assert (this.selectedProgram != null);
        ((ScrewdrivingSetupContribution)provider.get()).setSelectedProgram(this.selectedProgram);
    }

    private void reactToTeachButtonClicked(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        ScrewdrivingSetupContribution contribution = (ScrewdrivingSetupContribution)provider.get();
        contribution.getUserDefinedRobotPosition(new OnOkPositionCallback(parameters -> {
            contribution.setScrewPose(parameters.getPose());
            this.enableVerifyPositionButton(true);
        }));
    }

    private void reactToSpinTargetCheckBox(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        ScrewdrivingSetupContribution contribution = (ScrewdrivingSetupContribution)provider.get();
        boolean selected = this.spinTargetCheckBox.isSelected();
        contribution.setSpinTargetEnabled(selected);
        this.enableButtons(!selected);
        if (selected) {
            contribution.removeScrewPose();
            this.enableVerifyPositionButton(false);
        }
    }

    private void moveToScrew(@NotNull ContributionProvider<ScrewdrivingSetupContribution> provider) {
        ScrewdrivingSetupContribution contribution = (ScrewdrivingSetupContribution)provider.get();
        contribution.moveToScrew();
    }
}

