/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.unit;

import com.spin.ui.unit.ImperialConverter;
import com.spin.ui.unit.MetricConverter;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Torque;
import org.jetbrains.annotations.NotNull;

public abstract class UnitConverter {
    @NotNull
    public static UnitConverter create(@NotNull UnitType unitType, @NotNull SimpleValueFactory valueFactory) {
        switch (unitType) {
            case METRIC: {
                return new MetricConverter(valueFactory);
            }
            case IMPERIAL: {
                return new ImperialConverter(valueFactory);
            }
        }
        throw new IllegalArgumentException("Unknown unit type: " + unitType);
    }

    @NotNull
    protected abstract String lengthLabel();

    @NotNull
    protected abstract String forceLabel();

    @NotNull
    protected abstract String massLabel();

    @NotNull
    protected abstract String speedLabel();

    @NotNull
    protected abstract String torqueLabel();

    protected abstract double valueOf(@NotNull Length var1);

    protected abstract double valueOf(@NotNull Force var1);

    protected abstract double valueOf(@NotNull Mass var1);

    protected abstract double valueOf(@NotNull Speed var1);

    protected abstract double valueOf(@NotNull Torque var1);

    @NotNull
    protected abstract Length asLength(double var1);

    @NotNull
    protected abstract Force asForce(double var1);

    @NotNull
    protected abstract Mass asMass(double var1);

    @NotNull
    protected abstract Speed asSpeed(double var1);

    @NotNull
    protected abstract Torque asTorque(double var1);

    @NotNull
    public <Unit> String labelOf(Class<Unit> clazz) {
        if (Length.class.isAssignableFrom(clazz)) {
            return this.lengthLabel();
        }
        if (Force.class.isAssignableFrom(clazz)) {
            return this.forceLabel();
        }
        if (Mass.class.isAssignableFrom(clazz)) {
            return this.massLabel();
        }
        if (Speed.class.isAssignableFrom(clazz)) {
            return this.speedLabel();
        }
        if (Torque.class.isAssignableFrom(clazz)) {
            return this.torqueLabel();
        }
        throw new IllegalArgumentException("Unsupported class type: " + clazz);
    }

    public <Unit> double valueOf(@NotNull Class<Unit> clazz, @NotNull Object unitValue) {
        if (Length.class.isAssignableFrom(clazz)) {
            return this.valueOf((Length)unitValue);
        }
        if (Force.class.isAssignableFrom(clazz)) {
            return this.valueOf((Force)unitValue);
        }
        if (Mass.class.isAssignableFrom(clazz)) {
            return this.valueOf((Mass)unitValue);
        }
        if (Speed.class.isAssignableFrom(clazz)) {
            return this.valueOf((Speed)unitValue);
        }
        if (Torque.class.isAssignableFrom(clazz)) {
            return this.valueOf((Torque)unitValue);
        }
        throw new IllegalArgumentException("Unsupported class type: " + clazz);
    }

    @NotNull
    public <Unit> Unit asType(Class<Unit> clazz, double value) {
        if (Length.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asLength(value));
        }
        if (Force.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asForce(value));
        }
        if (Mass.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asMass(value));
        }
        if (Speed.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asSpeed(value));
        }
        if (Torque.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.asTorque(value));
        }
        throw new IllegalArgumentException("Unsupported class type: " + clazz);
    }
}

