/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.detach_bit;

import com.spin.core.program_node.detach_bit.DetachBitData;
import com.spin.core.program_node.detach_bit.DetachBitText;
import com.spin.domain.BitChangingStation;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DetachBitScriptGenerator {
    @NotNull
    private static InputStream variableDeclarationsScript() {
        return Objects.requireNonNull(DetachBitScriptGenerator.class.getResourceAsStream("variable_declarations.script"));
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(DetachBitScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    @NotNull
    private static InputStream directApproachScript() {
        return Objects.requireNonNull(DetachBitScriptGenerator.class.getResourceAsStream("direct_approach.script"));
    }

    @NotNull
    private static InputStream detachBitScript() {
        return Objects.requireNonNull(DetachBitScriptGenerator.class.getResourceAsStream("detach_bit.script"));
    }

    void generateScript(@NotNull ScriptWriter writer, @NotNull TextResource textResource, @NotNull DetachBitData data) {
        BitChangingStation.Bit bit = Objects.requireNonNull(data.selectedBit());
        BitChangingStation station = Objects.requireNonNull(data.selectedStation());
        Pose bitPose = station.poseOf(bit);
        Pose poseInFront = station.poseInFrontOf(bit);
        Pose endSafePose = station.poseEndSafe(bit);
        String errorMessage = ScriptUtil.wrapInQuotes(textResource.load(DetachBitText.ERROR_MESSAGE));
        String errorTitle = ScriptUtil.wrapInQuotes(textResource.load(DetachBitText.ERROR_TITLE));
        ScriptParser parser = new ScriptParser(writer);
        parser.parseToScript(DetachBitScriptGenerator.variableDeclarationsScript(), ScriptUtil.toScript(bitPose), ScriptUtil.toScript(poseInFront), ScriptUtil.toScript(endSafePose), errorMessage, errorTitle);
        parser.parseToScript(data.approachEnabled() ? DetachBitScriptGenerator.safeApproachScript() : DetachBitScriptGenerator.directApproachScript(), new String[0]);
        parser.parseToScript(DetachBitScriptGenerator.detachBitScript(), new String[0]);
    }
}

