/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.hidden_nodes.move_away;

import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayData;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayInterface;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayScriptGenerator;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayText;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayView;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAwayContribution
implements ProgramNodeContribution,
MoveAwayInterface {
    @NotNull
    private final MoveAwayView view;
    @NotNull
    private final MoveAwayData data;
    @NotNull
    private final MoveAwayScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UnitKeypadFactory unitKeypadFactory;

    MoveAwayContribution(@NotNull MoveAwayView view, @NotNull MoveAwayData data, @NotNull MoveAwayScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.unitKeypadFactory = apiProvider.getUnitKeypadFactory();
        view.setUnitConverter(apiProvider.getUnitConverter());
    }

    public void openView() {
        this.view.setMoveDistanceField(this.data.getMoveDistance());
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(MoveAwayText.MOVE_AWAY);
    }

    public boolean isDefined() {
        return this.data.getMoveDistance() != null;
    }

    public void generateScript(ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.data);
    }

    @Override
    public void setMoveDistance(@NotNull Length distance) {
        this.data.setMoveDistance(distance);
    }

    @NotNull
    UnitKeypad<Integer, Length> getMoveDistanceIntegerKeypad(@Nullable Length initialLength) {
        UnitKeypad<Integer, Length> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        return keypad;
    }

    @NotNull
    UnitKeypad<Double, Length> getMoveDistanceDoubleKeypad(@Nullable Length initialLength) {
        UnitKeypad<Double, Length> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        return keypad;
    }
}

