/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupView;
import com.spin.core.program_node.screwdriving_setup.approach.ApproachService;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewInterface;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewService;
import com.spin.core.program_node.screwdriving_setup.on_Fault.OnFaultService;
import com.spin.core.program_node.screwdriving_setup.on_OK.OnOkService;
import com.spin.core.program_node.screwdriving_setup.on_not_OK.OnNotOkService;
import com.spin.domain.BridgeInfo;
import com.spin.domain.Group;
import com.spin.domain.MultiInstall;
import com.spin.domain.Program;
import com.spin.ui.callback.DoNothingMovementCallback;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.api.NodeFactory;
import com.spin.util.logging.SpinLog;
import com.spin.util.script.ScriptUtil;
import com.spin.util.visitor.VisitURCapNodeAs;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.ExpressionAssignmentNodeConfig;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrewdrivingSetupContribution
implements ProgramNodeContribution {
    @NotNull
    private final ScrewdrivingSetupView view;
    @NotNull
    private final ScrewdrivingSetupData data;
    @NotNull
    private final ProgramModel programModel;
    @NotNull
    private final ExpressionBuilder expressionBuilder;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final RobotMovement robotMovement;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final String nodeTitle;
    @NotNull
    private final BridgeConnectionStatusProvider bridgeConnectionStatusProvider;
    @NotNull
    private final BridgeConnectionStatusListener bridgeConnectionStatusListener;
    @NotNull
    private final ExtendedProgramAPIProvider apiProvider;

    ScrewdrivingSetupContribution(@NotNull ScrewdrivingSetupView view, @NotNull ScrewdrivingSetupData data, @NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType creationType) throws TreeStructureException {
        this.apiProvider = apiProvider;
        this.view = view;
        this.data = data;
        this.programModel = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel();
        this.expressionBuilder = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.robotMovement = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction().getRobotMovement();
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
        this.nodeTitle = MultiInstall.prefix() + apiProvider.getTextResource().load(ScrewdrivingSetupText.SCREWDRIVING_SETUP);
        this.bridgeConnectionStatusProvider = ((InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class)).getBridgeConnectionStatusProvider();
        this.bridgeConnectionStatusListener = ScrewdrivingSetupContribution.createBridgeConnectionStatusListener(view);
        if (creationType == CreationContext.NodeCreationType.NEW) {
            Variable spin_target = NodeFactory.get_spin_target(apiProvider.getProgramAPIProvider().getProgramAPI());
            data.saveSpinTargetVariable(spin_target);
            this.buildSubTree();
        }
    }

    @NotNull
    private static BridgeConnectionStatusListener createBridgeConnectionStatusListener(final @NotNull ScrewdrivingSetupView view) {
        return new BridgeConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull BridgeInfo info) {
                view.setNotConnectedWarningVisible(false);
            }

            @Override
            public void onDisconnected() {
                view.setNotConnectedWarningVisible(true);
            }
        };
    }

    private void buildSubTree() throws TreeStructureException {
        TreeNode rootNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this);
        ProgramNodeFactory factory = this.programModel.getProgramNodeFactory();
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(ApproachService.class));
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(DriveScrewService.class));
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(OnOkService.class));
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(OnNotOkService.class));
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(OnFaultService.class));
        rootNode.setChildSequenceLocked(true);
    }

    public void openView() {
        this.updateSelectors();
        this.updateTeachAndVerifyButtons();
        this.updateBridgeConnectionStatus();
        this.updateUseSpinTargetCheckBox();
        this.data.setOnProgramDataChangedCallback(this::updateSelectors);
        this.bridgeConnectionStatusProvider.registerListener(this.bridgeConnectionStatusListener);
    }

    public void closeView() {
        this.data.clearOnProgramsDataChangedCallback();
        this.bridgeConnectionStatusProvider.unregisterListener(this.bridgeConnectionStatusListener);
    }

    @NotNull
    public String getTitle() {
        Program selectedProgram = this.data.selectedProgram();
        return selectedProgram == null ? this.nodeTitle : this.nodeTitle + ": " + selectedProgram.name();
    }

    public boolean isDefined() {
        return this.data.isValid();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        SpinLog.print("ScrewdrivingSetupContribution.generateScript");
        this.configureSubTree();
        if (!this.data.useSpinTarget()) {
            SpinLog.print("ScrewdrivingSetupContribution.generateScript: !data.useSpinTarget()");
            String screw_pose = ScriptUtil.toScript(Objects.requireNonNull(this.data.screwPose()));
            Variable spin_target = NodeFactory.get_spin_target(this.apiProvider.getProgramAPIProvider().getProgramAPI());
            writer.assign(spin_target, screw_pose);
        }
        Program selected_program = Objects.requireNonNull(this.data.selectedProgram());
        double start_depth_offset_m = selected_program.start_depth().getAs(Length.Unit.M) - selected_program.reference_depth().getAs(Length.Unit.M);
        double inital_safety_shield_position_mm = selected_program.inital_safety_shield_position().getAs(Length.Unit.MM);
        writer.appendLine("global " + MultiInstall.urscriptPrefix() + "inital_safety_shield_position_mm =" + inital_safety_shield_position_mm);
        writer.appendLine("global " + MultiInstall.urscriptPrefix() + "start_offset = " + start_depth_offset_m);
        writer.writeChildren();
    }

    private void configureSubTree() {
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).traverse(new VisitURCapNodeAs<DriveScrewInterface>(DriveScrewInterface.class, (node, index, depth) -> node.setData(this.data)));
    }

    void setSpinTargetEnabled(boolean enable) {
        this.undoRedoManager.recordChanges(() -> {
            this.data.setUseSpinTarget(enable);
            this.enableSpinTargetInProgramTree(enable);
        });
    }

    void setSelectedGroup(@Nullable Group selectedGroup) {
        this.data.setSelectedGroup(selectedGroup);
        this.data.clearSelectedProgram();
        Set<Program> programs = selectedGroup == null ? this.data.getPrograms() : this.data.getPrograms(selectedGroup.programs());
        this.view.setPrograms(programs);
        this.view.selectProgram(null);
        this.view.setNoProgramsWarningVisible(programs.isEmpty());
        this.view.enableProgramSelector(!programs.isEmpty());
    }

    void setSelectedProgram(@NotNull Program selectedProgram) {
        this.data.setSelectedProgram(selectedProgram);
    }

    void getUserDefinedRobotPosition(@NotNull RobotPositionCallback2 callback) {
        this.userInteraction.getUserDefinedRobotPosition(callback);
    }

    void setScrewPose(@NotNull Pose pose) {
        this.data.setScrewPose(pose);
        this.view.setButtonStyleAsReteach();
    }

    void removeScrewPose() {
        this.data.removeScrewPose();
        this.view.setButtonStyleAsTeach();
    }

    void moveToScrew() {
        Pose screwPose = this.data.screwPose();
        assert (screwPose != null);
        this.robotMovement.requestUserToMoveRobot(screwPose, (RobotMovementCallback)new DoNothingMovementCallback());
    }

    private void enableSpinTargetInProgramTree(boolean enable) {
        try {
            if (enable) {
                this.addSpinTargetNode();
            } else {
                this.removeSpinTargetNode();
            }
        }
        catch (TreeStructureException e) {
            throw new RuntimeException(e);
        }
    }

    private void addSpinTargetNode() throws TreeStructureException {
        TreeNode rootNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this);
        TreeNode firstNode = (TreeNode)rootNode.getChildren().get(0);
        rootNode.insertChildBefore(firstNode, (ProgramNode)this.createSpinTargetNode());
    }

    @NotNull
    private AssignmentNode createSpinTargetNode() {
        AssignmentNode assignmentNode = this.programModel.getProgramNodeFactory().createAssignmentNode();
        ExpressionAssignmentNodeConfig config = assignmentNode.getConfigFactory().createExpressionConfig(NodeFactory.get_spin_target(this.apiProvider.getProgramAPIProvider().getProgramAPI()), this.createEmptyExpression());
        assignmentNode.setConfig((AssignmentNodeConfig)config);
        return assignmentNode;
    }

    @NotNull
    private Expression createEmptyExpression() {
        try {
            return this.expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeSpinTargetNode() throws TreeStructureException {
        TreeNode rootNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this);
        TreeNode firstNode = (TreeNode)rootNode.getChildren().get(0);
        assert (firstNode.getProgramNode() instanceof AssignmentNode);
        rootNode.removeChild(firstNode);
    }

    private void updateSelectors() {
        Set<Group> availableParts = this.data.availableGroups();
        Set<Program> availablePrograms = this.data.availablePrograms();
        Group selectedPart = this.data.selectedGroup();
        Program selectedProgram = this.data.selectedProgram();
        this.view.setGroups(availableParts);
        this.view.selectPart(selectedPart);
        this.view.enablePartSelector(!availableParts.isEmpty());
        this.view.setNoPartsWarningVisible(availableParts.isEmpty());
        this.view.setPrograms(availablePrograms);
        this.view.selectProgram(selectedProgram);
        this.view.enableProgramSelector(!availablePrograms.isEmpty());
        this.view.setNoProgramsWarningVisible(!availableParts.isEmpty() && availablePrograms.isEmpty());
    }

    private void updateTeachAndVerifyButtons() {
        if (this.data.useSpinTarget()) {
            this.view.enableButtons(false);
            this.view.enableVerifyPositionButton(false);
        } else {
            this.view.enableButtons(true);
            if (this.data.screwPose() == null) {
                this.view.setButtonStyleAsTeach();
                this.view.enableVerifyPositionButton(false);
            } else {
                this.view.setButtonStyleAsReteach();
                this.view.enableVerifyPositionButton(true);
            }
        }
    }

    private void updateBridgeConnectionStatus() {
        this.view.setNotConnectedWarningVisible(!this.bridgeConnectionStatusProvider.isConnected());
    }

    private void updateUseSpinTargetCheckBox() {
        this.view.setSpinTargetEnabled(this.data.useSpinTarget());
    }
}

