/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util;

import com.spin.util.URSimUtil;
import com.spin.util.logging.SpinLog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class ExhibitionMode {
    @NotNull
    private static String exhibitionModeMarkerFilePath() {
        return URSimUtil.isURSimContainer() ? "/urcaps/exhibition_mode_enabled" : "/data/root/.urcaps/exhibition_mode_enabled";
    }

    private static void showPopup(String message) {
        JFrame frame = new JFrame();
        JOptionPane.showMessageDialog(frame, message);
    }

    private static void enable() throws IOException {
        File markerFile = new File(ExhibitionMode.exhibitionModeMarkerFilePath());
        if (markerFile.createNewFile()) {
            ExhibitionMode.showPopup("Exhibition mode enabled, reebot the robot to apply changes");
        } else {
            SpinLog.print("Unable to create marker file: " + markerFile);
        }
    }

    private static void disable() {
        File markerFile = new File(ExhibitionMode.exhibitionModeMarkerFilePath());
        if (markerFile.delete()) {
            ExhibitionMode.showPopup("Exhibition mode disabled, reebot the robot to apply changes");
        } else {
            SpinLog.print("Unable to delete marker file: " + markerFile);
        }
    }

    public static void toggle() throws IOException {
        if (ExhibitionMode.isEnabled()) {
            ExhibitionMode.disable();
        } else {
            ExhibitionMode.enable();
        }
    }

    public static boolean isEnabled() {
        Path path = Paths.get(ExhibitionMode.exhibitionModeMarkerFilePath(), new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }
}

