/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.tool_connection;

import com.spin.bridge_communication.tool_connection.ToolConnectionStatusListener;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusProvider;
import com.spin.domain.ToolInfo;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolConnectionStatusDispatcher
implements ToolConnectionStatusProvider,
ToolConnectionStatusListener {
    @NotNull
    private final Set<ToolConnectionStatusListener> listeners = new HashSet<ToolConnectionStatusListener>();
    @Nullable
    private ToolInfo info = null;

    @Override
    public boolean isConnected() {
        return this.info != null;
    }

    @Override
    @NotNull
    public Optional<ToolInfo> getInfo() {
        return Optional.ofNullable(this.info);
    }

    @Override
    public void onConnected(@NotNull ToolInfo info) {
        this.info = info;
        this.forwardOnConnected(info);
    }

    @Override
    public void onDisconnected() {
        this.info = null;
        this.forwardOnDisconnected();
    }

    @Override
    public void registerListener(@NotNull ToolConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(@NotNull ToolConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    private void forwardOnConnected(@NotNull ToolInfo info) {
        for (ToolConnectionStatusListener listener : this.listeners) {
            listener.onConnected(info);
        }
    }

    private void forwardOnDisconnected() {
        for (ToolConnectionStatusListener listener : this.listeners) {
            listener.onDisconnected();
        }
    }
}

