/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.move_to_screw;

import com.spin.core.program_node.move_to_screw.MoveToScrewData;
import com.spin.core.program_node.move_to_screw.MoveToScrewText;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MoveToScrewScriptGenerator {
    @NotNull
    private static InputStream variableDeclarationsScript() {
        return Objects.requireNonNull(MoveToScrewScriptGenerator.class.getResourceAsStream("variable_declarations.script"));
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(MoveToScrewScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    @NotNull
    private static InputStream directApproachScript() {
        return Objects.requireNonNull(MoveToScrewScriptGenerator.class.getResourceAsStream("direct_approach.script"));
    }

    @NotNull
    private static InputStream moveToScrewScript() {
        return Objects.requireNonNull(MoveToScrewScriptGenerator.class.getResourceAsStream("move_to_screw.script"));
    }

    public void generateScript(ScriptWriter writer, TextResource textResource, MoveToScrewData data) {
        Pose screwPose = data.getPose();
        String errorMessage = ScriptUtil.wrapInQuotes(textResource.load(MoveToScrewText.ERROR_TITLE));
        String errorTitle = ScriptUtil.wrapInQuotes(textResource.load(MoveToScrewText.ERROR_TITLE));
        ScriptParser parser = new ScriptParser(writer);
        parser.parseToScript(MoveToScrewScriptGenerator.variableDeclarationsScript(), ScriptUtil.toScript(screwPose), errorMessage, errorTitle);
        parser.parseToScript(data.approachEnabled() ? MoveToScrewScriptGenerator.safeApproachScript() : MoveToScrewScriptGenerator.directApproachScript(), new String[0]);
        parser.parseToScript(MoveToScrewScriptGenerator.moveToScrewScript(), new String[0]);
    }
}

