/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.discovery;

import com.spin.bridge_communication.discovery.BridgeDiscovery;
import com.spin.domain.DiscoveredBridge;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.time.LocalDateTime;

public class MulticastReceiverTask
implements Runnable {
    private final BridgeDiscovery bridgeDiscovery;
    private final InetAddress group;
    private final MulticastSocket socket;
    private final byte[] buf = new byte[256];

    MulticastReceiverTask(BridgeDiscovery bridgeDiscovery, InetAddress multiCastGroupAddress, int multiCastGroupPort) throws IOException {
        this.bridgeDiscovery = bridgeDiscovery;
        this.group = multiCastGroupAddress;
        this.socket = new MulticastSocket(multiCastGroupPort);
    }

    @Override
    public void run() {
        try {
            this.socket.joinGroup(this.group);
            while (!Thread.interrupted()) {
                DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length);
                this.socket.receive(packet);
                String hostname = new String(packet.getData(), 0, packet.getLength());
                InetAddress ip = packet.getAddress();
                LocalDateTime lastSeen = LocalDateTime.now();
                DiscoveredBridge bridge = new DiscoveredBridge(hostname, ip, lastSeen);
                this.bridgeDiscovery.enqueue(bridge);
            }
            this.socket.leaveGroup(this.group);
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

