/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.screw_feeder;

import com.spin.core.installation_node.screw_feeder.ScrewFeederContribution;
import com.spin.core.installation_node.screw_feeder.ScrewFeederText;
import com.spin.domain.ScrewFeeder;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.Label;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.unit.UnitConverter;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FeederDetailsView {
    @NotNull
    private final JComboBox<ScrewFeeder> feederSelector;
    @NotNull
    private final JButton editButton;
    @NotNull
    private final JButton deleteButton;
    @NotNull
    private final JButton verifyPositionButton;
    @NotNull
    private final JButton addNewFeederButton;
    @NotNull
    private final Label screwLengthLabel;
    @NotNull
    private final Label screwLengthValue;
    @Nullable
    private UnitConverter unitConverter = null;
    @NotNull
    private Set<ScrewFeeder> feeders = Collections.emptySet();

    FeederDetailsView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        ImageIcon deleteIcon = UR_Icon.DELETE.load();
        ImageIcon editIcon = UR_Icon.EDIT.load();
        ImageIcon wizardIcon = UR_Icon.WIZARD.load();
        ImageIcon addIcon = UR_Icon.PLUS.load();
        this.feederSelector = new ComboBox<ScrewFeeder>();
        this.screwLengthLabel = new Label(textResource.load(ScrewFeederText.SCREW_LENGTH));
        this.screwLengthValue = new Label();
        this.verifyPositionButton = new ButtonMedium(textResource.load(ScrewFeederText.VERIFY_POSITION), wizardIcon);
        this.editButton = new ButtonMedium(editIcon);
        this.deleteButton = new ButtonMedium(deleteIcon);
        ButtonMedium button = new ButtonMedium(textResource.load(ScrewFeederText.ADD_NEW_FEEDER), addIcon);
        button.enableCallToActionStyle(true);
        this.addNewFeederButton = button;
    }

    @NotNull
    JPanel createPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(6, 20, "50[]10[]20[]50[]push[]100"));
        panel.add(this.feederSelector, "cell 1 0, span 4, grow");
        panel.add((Component)this.screwLengthLabel, "cell 1 1, span 2, grow");
        panel.add((Component)this.screwLengthValue, "cell 4 1, right");
        panel.add((Component)this.verifyPositionButton, "cell 1 2, span 4, grow");
        panel.add((Component)this.editButton, "cell 1 3, span 2, grow");
        panel.add((Component)this.deleteButton, "cell 3 3, span 2, grow");
        panel.add((Component)this.addNewFeederButton, "cell 1 4, span 4, grow");
        return panel;
    }

    void registerListeners(@NotNull ScrewFeederContribution contribution) {
        this.feederSelector.addActionListener(event -> this.updateDetailsForSelectedFeeder());
        this.verifyPositionButton.addActionListener(event -> this.showVerifyPositionWizard(contribution));
        this.editButton.addActionListener(event -> this.showEditFeederWizard(contribution));
        this.deleteButton.addActionListener(event -> this.deleteSelectedFeeder(contribution));
        this.addNewFeederButton.addActionListener(event -> this.showAddNewFeederWizard(contribution));
    }

    void setUnitConverter(@NotNull UnitConverter unitConverter) {
        this.unitConverter = unitConverter;
    }

    void setFeeders(@NotNull Set<ScrewFeeder> feeders) {
        this.feeders = feeders;
        this.feederSelector.removeAllItems();
        feeders.stream().sorted(Comparator.comparing(feeder -> feeder.name().toLowerCase()).thenComparing(ScrewFeeder::name)).forEach(this.feederSelector::addItem);
        this.enableComponents(!feeders.isEmpty());
        this.updateDetailsForSelectedFeeder();
    }

    void selectFeederByID(@NotNull UUID id) {
        ScrewFeeder feederToSelect = this.feeders.stream().filter(feeder -> feeder.id().equals(id)).findFirst().orElse(null);
        assert (feederToSelect != null);
        this.feederSelector.setSelectedItem(feederToSelect);
    }

    private void enableComponents(boolean enable) {
        Stream.of(this.feederSelector, this.screwLengthLabel, this.screwLengthValue, this.verifyPositionButton, this.editButton, this.deleteButton).forEach(component -> component.setEnabled(enable));
    }

    private void updateDetailsForSelectedFeeder() {
        ScrewFeeder feeder = (ScrewFeeder)this.feederSelector.getSelectedItem();
        String text = feeder == null ? null : this.toString(feeder.screwLength());
        this.screwLengthValue.setText(text);
    }

    @NotNull
    private String toString(@NotNull Length screwLength) {
        assert (this.unitConverter != null) : "setScrewLength called before setUnitConverter";
        double value = this.unitConverter.valueOf(Length.class, screwLength);
        String unit = this.unitConverter.labelOf(Length.class);
        return new DecimalFormat("#.##").format(value) + " " + unit;
    }

    private void deleteSelectedFeeder(@NotNull ScrewFeederContribution contribution) {
        ScrewFeeder selectedFeeder = (ScrewFeeder)this.feederSelector.getSelectedItem();
        assert (selectedFeeder != null);
        contribution.removeFeeder(selectedFeeder);
    }

    private void showVerifyPositionWizard(@NotNull ScrewFeederContribution contribution) {
        ScrewFeeder selectedFeeder = (ScrewFeeder)this.feederSelector.getSelectedItem();
        assert (selectedFeeder != null);
        contribution.onVerifyExistingPosition(selectedFeeder.pickUpPose());
    }

    private void showEditFeederWizard(@NotNull ScrewFeederContribution contribution) {
        ScrewFeeder selectedFeeder = (ScrewFeeder)this.feederSelector.getSelectedItem();
        assert (selectedFeeder != null);
        contribution.onEditExistingFeeder(selectedFeeder);
    }

    private void showAddNewFeederWizard(@NotNull ScrewFeederContribution contribution) {
        contribution.onAddNewFeeder();
    }
}

