/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.bridge_connection;

import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.domain.BridgeInfo;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BridgeConnectionStatusDispatcher
implements BridgeConnectionStatusProvider,
BridgeConnectionStatusListener {
    @NotNull
    private final Set<BridgeConnectionStatusListener> listeners = new HashSet<BridgeConnectionStatusListener>();
    @Nullable
    private BridgeInfo info = null;

    @Override
    public boolean isConnected() {
        return this.info != null;
    }

    @Override
    @NotNull
    public Optional<BridgeInfo> getInfo() {
        return Optional.ofNullable(this.info);
    }

    @Override
    public void onConnected(@NotNull BridgeInfo info) {
        this.info = info;
        this.forwardOnConnected(info);
    }

    @Override
    public void onDisconnected() {
        this.info = null;
        this.forwardOnDisconnected();
    }

    @Override
    public void registerListener(@NotNull BridgeConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(@NotNull BridgeConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    private void forwardOnConnected(@NotNull BridgeInfo info) {
        for (BridgeConnectionStatusListener listener : this.listeners) {
            listener.onConnected(info);
        }
    }

    private void forwardOnDisconnected() {
        for (BridgeConnectionStatusListener listener : this.listeners) {
            listener.onDisconnected();
        }
    }
}

