/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import com.ur.urcap.api.domain.SoftwareVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SpinSoftwareVersion
implements Comparable<SpinSoftwareVersion> {
    private static SpinSoftwareVersion minimumBridgeVersion;
    private static SpinSoftwareVersion thisURCapVersion;
    @NotNull
    private final String softwareVersion;

    public static void setMinimumBridgeVersion(SpinSoftwareVersion minimumBridgeVersion) {
        SpinSoftwareVersion.minimumBridgeVersion = minimumBridgeVersion;
    }

    public static void setThisURCapVersion(SpinSoftwareVersion thisURCapVersion) {
        SpinSoftwareVersion.thisURCapVersion = thisURCapVersion;
    }

    private SpinSoftwareVersion(@NotNull String softwareVersionString) {
        this.softwareVersion = softwareVersionString;
    }

    @NotNull
    public static SpinSoftwareVersion parse(@NotNull String softwareVersionString) {
        return new SpinSoftwareVersion(softwareVersionString);
    }

    @NotNull
    public static SpinSoftwareVersion parse(@NotNull SoftwareVersion softwareVersion) {
        int major = softwareVersion.getMajorVersion();
        int minor = softwareVersion.getMinorVersion();
        int bugfix = softwareVersion.getBugfixVersion();
        return new SpinSoftwareVersion(String.format("%d.%d.%d", major, minor, bugfix));
    }

    @NotNull
    public static SpinSoftwareVersion getMinimumBridgeVersion() {
        return minimumBridgeVersion;
    }

    @NotNull
    public static SpinSoftwareVersion getThisURCapVersion() {
        return thisURCapVersion;
    }

    public boolean isNewerThan(@NotNull SpinSoftwareVersion other) {
        return this.compareTo(other) > 0;
    }

    @NotNull
    public String toString() {
        return this.softwareVersion;
    }

    private String[] getVersionParts(String softwareVersion) {
        Pattern pattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+).*");
        Matcher matcher = pattern.matcher(softwareVersion);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid software version: " + softwareVersion);
        }
        String version = matcher.group(1);
        return version.split("\\.");
    }

    @Override
    public int compareTo(@NotNull SpinSoftwareVersion other) {
        Pattern pattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+).*");
        Matcher matcher1 = pattern.matcher(this.softwareVersion);
        if (!matcher1.matches()) {
            throw new RuntimeException("Invalid software version: " + this.softwareVersion);
        }
        String thisVersion = matcher1.group(1);
        Matcher matcher2 = pattern.matcher(other.toString());
        if (!matcher2.matches()) {
            throw new RuntimeException("Invalid software version: " + other);
        }
        String otherVersion = matcher2.group(1);
        String[] thisVersionParts = this.getVersionParts(thisVersion);
        String[] otherVersionParts = this.getVersionParts(otherVersion);
        int thisMajor = Integer.parseInt(thisVersionParts[0]);
        int thisMinor = Integer.parseInt(thisVersionParts[1]);
        int thisPatch = Integer.parseInt(thisVersionParts[2]);
        int otherMajor = Integer.parseInt(otherVersionParts[0]);
        int otherMinor = Integer.parseInt(otherVersionParts[1]);
        int otherPatch = Integer.parseInt(otherVersionParts[2]);
        if (thisMajor > otherMajor) {
            return 1;
        }
        if (thisMajor < otherMajor) {
            return -1;
        }
        if (thisMinor > otherMinor) {
            return 1;
        }
        if (thisMinor < otherMinor) {
            return -1;
        }
        if (thisPatch > otherPatch) {
            return 1;
        }
        if (thisPatch < otherPatch) {
            return -1;
        }
        return 0;
    }
}

