/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.move_to_screw;

import com.spin.core.program_node.move_to_screw.MoveToScrewData;
import com.spin.core.program_node.move_to_screw.MoveToScrewScriptGenerator;
import com.spin.core.program_node.move_to_screw.MoveToScrewText;
import com.spin.core.program_node.move_to_screw.MoveToScrewView;
import com.spin.ui.callback.DoNothingMovementCallback;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final MoveToScrewView view;
    @NotNull
    private final MoveToScrewData data;
    @NotNull
    private final MoveToScrewScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final PoseFactory poseFactory;
    @NotNull
    private final RobotMovement robotMovement;

    MoveToScrewContribution(@NotNull MoveToScrewView moveToScrewView, @NotNull MoveToScrewData data, @NotNull MoveToScrewScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = moveToScrewView;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
        this.poseFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getPoseFactory();
        this.robotMovement = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction().getRobotMovement();
    }

    public void openView() {
        this.view.setReverseDirection(this.data.reverseDirection());
        this.view.setIgnoreSafetyShield(this.data.ignoreSafetyShield());
        this.view.setApproachEnabled(this.data.approachEnabled());
        if (this.data.getPose() == null) {
            this.view.setButtonStyleAsTeach();
            this.view.verifyPositionButtonEnabled(false);
        } else {
            this.view.setButtonStyleAsReTeach();
            this.view.verifyPositionButtonEnabled(true);
        }
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(MoveToScrewText.MOVE_TO_SCREW_TITLE);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    public void generateScript(ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    void setReverseDirection(boolean reverseDirection) {
        this.data.setReverseDirection(reverseDirection);
    }

    void setIgnoreSafetyShield(boolean ignoreSafetyShield) {
        this.data.setIgnoreSafetyShield(ignoreSafetyShield);
    }

    void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    void setPose(@NotNull Pose pose) {
        this.data.setPose(pose);
    }

    @Nullable
    Pose pose() {
        return this.data.getPose();
    }

    @NotNull
    UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    void moveToScrew() {
        Pose screwPose = this.pose();
        assert (screwPose != null);
        this.robotMovement.requestUserToMoveRobot(screwPose, (RobotMovementCallback)new DoNothingMovementCallback());
    }
}

