/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.connector;

import com.spin.bridge_communication.proxy.state_machine.Connector;
import com.spin.bridge_communication.proxy.xmlrpc_client.XmlRpcBridgeClient;
import com.spin.util.SpinLog;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRpcConnector
implements Connector {
    private static final long initialSchedulingDelay_ms = 0L;
    private static final long schedulingPeriod_ms = 2000L;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final XmlRpcBridgeClient bridgeClient;
    @Nullable
    private ScheduledFuture<?> connectTask = null;
    private Runnable onSuccessCallback = () -> SpinLog.print("No onConnectSuccess callback has been set");

    public XmlRpcConnector(@NotNull ScheduledExecutorService executor, @NotNull XmlRpcBridgeClient bridgeClient) {
        this.executor = executor;
        this.bridgeClient = bridgeClient;
    }

    public void setOnSuccessCallback(@NotNull Runnable callback) {
        this.onSuccessCallback = callback;
    }

    @Override
    public void startConnecting() {
        this.connectTask = this.executor.scheduleAtFixedRate(this::tryToConnect, 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stopConnecting() {
        assert (this.connectTask != null);
        this.connectTask.cancel(false);
    }

    private void tryToConnect() {
        try {
            this.connectAndNotifyListener();
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    private void connectAndNotifyListener() throws XmlRpcException {
        this.bridgeClient.connect();
        this.onSuccessCallback.run();
    }
}

