/*
 * Decompiled with CFR 0.152.
 */
package com.spin.api;

import com.spin.i18n.TextResource;
import com.spin.math.PoseMath;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ExtendedInstallationAPIProvider {
    @NotNull
    private final InstallationAPIProvider installationAPIProvider;

    public ExtendedInstallationAPIProvider(@NotNull InstallationAPIProvider installationAPIProvider) {
        this.installationAPIProvider = installationAPIProvider;
    }

    @NotNull
    public InstallationAPIProvider getInstallationAPIProvider() {
        return this.installationAPIProvider;
    }

    @NotNull
    public TextResource getTextResource() {
        Locale locale = this.installationAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale();
        return TextResource.defaultTextResource(locale);
    }

    @NotNull
    public UnitConverter getUnitConverter() {
        UnitType unitType = this.installationAPIProvider.getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        SimpleValueFactory factory = this.installationAPIProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory();
        return UnitConverter.create(unitType, factory);
    }

    public UnitKeypadFactory getUnitKeypadFactory() {
        KeyboardInputFactory factory = this.installationAPIProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        return new UnitKeypadFactory(factory, this.getUnitConverter(), this.getTextResource());
    }

    @NotNull
    public PoseMath getPoseMath() {
        return new PoseMath(this.installationAPIProvider.getInstallationAPI().getValueFactoryProvider());
    }
}

