/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw;

import com.spin.core.program_node.load_screw.LoadScrewData;
import com.spin.core.program_node.load_screw.LoadScrewText;
import com.spin.domain.ScrewFeeder;
import com.spin.i18n.TextResource;
import com.spin.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LoadScrewScriptGenerator {
    void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull TextResource textResource, @NotNull LoadScrewData data) {
        ScrewFeeder feeder = data.selectedScrewFeeder();
        Pose feederPose = feeder.pickUpPose();
        Length screwLength = feeder.screwLength();
        InputStream loadScrewScript = Objects.requireNonNull(this.getClass().getResourceAsStream("LoadScrew.script"));
        ScriptParser parser = new ScriptParser(scriptWriter);
        parser.parseToScript(loadScrewScript, this.poseToScriptString(feederPose), Double.toString(screwLength.getAs(Length.Unit.M)), this.boolToString(data.approachEnabled()), this.boolToString(data.departEnabled()), "\"" + textResource.load(LoadScrewText.ERROR_MESSAGE) + "\"", "\"" + textResource.load(LoadScrewText.ERROR_TITLE) + "\"");
    }

    private String poseToScriptString(@NotNull Pose pose) {
        double[] values = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        assert (values.length == 6);
        return String.format("p[%f, %f, %f, %f, %f, %f]", values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    private String boolToString(@NotNull Boolean bool) {
        return bool != false ? "True" : "False";
    }
}

