/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util.soft_safety;

import com.spin.urcap.impl.util.soft_safety.SoftSafety;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.simple.Force;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftSafetyData {
    private final DataModel model;

    public SoftSafetyData(DataModel model) {
        this.model = model;
    }

    public void saveSoftSafety(SoftSafety softSafety) {
        this.saveSafetyEnabled(softSafety.isSafetyEnabled());
        this.saveSafetyForce(softSafety.getSafetyForce());
    }

    @NotNull
    public SoftSafety loadSoftSafety() {
        SoftSafety softSafety = SoftSafety.softSafetyFactory();
        Force safetyForce = this.loadSafetyForce();
        if (safetyForce != null) {
            softSafety.setSafetyForce(safetyForce);
        }
        softSafety.setSafetyEnabled(this.loadSafetyEnabled());
        return softSafety;
    }

    private void saveSafetyForce(@NotNull Force force) {
        this.model.set(SoftSafetyKey.SAFETY_FORCE.name(), force);
    }

    @Nullable
    private Force loadSafetyForce() {
        return this.model.get(SoftSafetyKey.SAFETY_FORCE.name(), (Force)null);
    }

    private void saveSafetyEnabled(boolean enabled) {
        this.model.set(SoftSafetyKey.SAFETY_ENABLED.name(), enabled);
    }

    private boolean loadSafetyEnabled() {
        return this.model.get(SoftSafetyKey.SAFETY_ENABLED.name(), true);
    }

    static enum SoftSafetyKey {
        SAFETY_ENABLED,
        SAFETY_FORCE;

    }
}

