/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.settings;

import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCClient;
import com.spin.urcap.impl.installation_node.InstallationContribution;
import com.spin.urcap.impl.installation_node.settings.SettingsTabView;
import com.spin.urcap.impl.localization.CommandNamesResource;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.util.Bridge;
import com.spin.urcap.impl.util.PopupTool;
import com.spin.urcap.impl.util.Tool;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.EventQueue;
import java.util.Timer;
import java.util.TimerTask;

public class SettingsTabContribution {
    private static final String KEY_LED_INTENSITY = "KEY_LED_INTENSITY";
    private static final String KEY_BUZZER_INTENSITY = "KEY_BUZZER_INTENSITY";
    private static final String KEY_BRIDGE_IP = "KEY_BRIDGE_IP";
    private final SettingsTabView settingsTabView;
    private final DataModel model;
    private final LanguagePack languagePack;
    private final KeyboardTextInput keyboardFactoryIp;
    private Timer uiTimer;

    public SettingsTabContribution(InstallationAPIProvider apiProvider, SettingsTabView settingsTabView, DataModel model) {
        this.settingsTabView = settingsTabView;
        this.model = model;
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.keyboardFactoryIp = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createStringKeyboardInput();
    }

    public void initDataModel() {
    }

    public String NodeTitle() {
        return this.getCommandNamesResource().nodeTabSettingInstallation();
    }

    public TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    private CommandNamesResource getCommandNamesResource() {
        return this.languagePack.getCommandNamesResource();
    }

    public void openView() {
        Bridge bridgeSettings = this.getBridgeSettings();
        Tool toolSettings = this.getToolSettings();
        this.settingsTabView.setLblBridgeSoftwareVersion(this.getTextResource().bridgeSoftwareVersionInstallationSetting() + bridgeSettings.softwareVersion);
        this.settingsTabView.setLblToolFirmwareVersion(this.getTextResource().toolFirmwareVersionInstallationSetting() + toolSettings.firmwareVersion);
        this.settingsTabView.setLblBridgeSerialNumber(this.getTextResource().installationSettingBridgeSerialNumber() + bridgeSettings.serialNumber);
        this.settingsTabView.setLblToolSerialNumber(this.getTextResource().installationSettingToolSerialNumber() + toolSettings.serialNumber);
        this.settingsTabView.setLblSDName(this.getTextResource().installationSettingTool() + this.getToolName(toolSettings.serialNumber));
        this.settingsTabView.setLblLEDSlider(this.getTextResource().installationSettingLEDLabel());
        this.settingsTabView.setLblBuzzer(this.getTextResource().installationSettingBuzzerLabel());
        final int[] threadCheck = new int[]{0};
        this.uiTimer = new Timer(true);
        this.uiTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (threadCheck[0] < 2) {
                            if (threadCheck[0] < 1) {
                                try {
                                    if (new XMLRPCClient().ping().booleanValue()) {
                                        threadCheck[0] = 1;
                                    }
                                    return;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Bridge bridgeSettings = SettingsTabContribution.this.getBridgeSettings();
                            Tool toolSettings = SettingsTabContribution.this.getToolSettings();
                            SettingsTabContribution.this.settingsTabView.setLblBridgeSoftwareVersion(SettingsTabContribution.this.getTextResource().bridgeSoftwareVersionInstallationSetting() + bridgeSettings.softwareVersion);
                            SettingsTabContribution.this.settingsTabView.setLblToolFirmwareVersion(SettingsTabContribution.this.getTextResource().toolFirmwareVersionInstallationSetting() + toolSettings.firmwareVersion);
                            SettingsTabContribution.this.settingsTabView.setLblBridgeSerialNumber(SettingsTabContribution.this.getTextResource().installationSettingBridgeSerialNumber() + bridgeSettings.serialNumber);
                            SettingsTabContribution.this.settingsTabView.setLblToolSerialNumber(SettingsTabContribution.this.getTextResource().installationSettingToolSerialNumber() + toolSettings.serialNumber);
                            SettingsTabContribution.this.settingsTabView.setLblSDName(SettingsTabContribution.this.getTextResource().installationSettingTool() + " " + SettingsTabContribution.this.getToolName(toolSettings.serialNumber));
                            SettingsTabContribution.this.settingsTabView.setLblLEDSlider(SettingsTabContribution.this.getTextResource().installationSettingLEDLabel());
                            SettingsTabContribution.this.settingsTabView.setLblBuzzer(SettingsTabContribution.this.getTextResource().installationSettingBuzzerLabel());
                        }
                    }
                });
            }
        }, 0L, 1000L);
    }

    public void closeView() {
        if (this.uiTimer != null) {
            this.uiTimer.cancel();
        }
    }

    public String getTitleText() {
        return this.getTextResource().installationSettingTitle();
    }

    public Bridge getBridgeSettings() {
        try {
            return new XMLRPCClient().getBridge();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Bridge();
        }
    }

    public Tool getToolSettings() {
        try {
            return new XMLRPCClient().getTool();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Tool();
        }
    }

    public int getLedIntensity() {
        return this.model.get(KEY_LED_INTENSITY, 100);
    }

    public void setLedIntensity(int value) {
        this.model.set(KEY_LED_INTENSITY, value);
    }

    public boolean getBuzzerIntensity() {
        return this.model.get(KEY_BUZZER_INTENSITY, true);
    }

    public void setBuzzerIntensity(boolean state) {
        this.model.set(KEY_BUZZER_INTENSITY, state);
    }

    public String getBridgeIP() {
        return this.model.get(KEY_BRIDGE_IP, "192.168.37.1");
    }

    public void setBridgeIP(String ip) {
        this.model.set(KEY_BRIDGE_IP, ip);
        new InstallationContribution().updateBridgeIp(ip);
    }

    public String getSetBridgeIPName() {
        return this.getTextResource().installationSettingSetSpinBridgeIP();
    }

    public String getToolName(String serialNumber) {
        String toolName = this.getTextResource().installationSettingNoToolConnection();
        if (serialNumber.length() == 12) {
            String model = serialNumber.substring(3, 4);
            switch (Integer.parseInt(model)) {
                case 1: {
                    toolName = this.getTextResource().installationSettingSD35();
                    break;
                }
                case 2: {
                    toolName = this.getTextResource().installationSettingSD70();
                    break;
                }
                default: {
                    return this.getTextResource().installationSettingToolNotExist();
                }
            }
        }
        return toolName;
    }

    public KeyboardTextInput getKeyboardForIp() {
        KeyboardTextInput keyboardInput = this.keyboardFactoryIp;
        keyboardInput.setInitialValue(this.getBridgeIP());
        return keyboardInput;
    }

    public KeyboardInputCallback<String> getCallbackForIp() {
        return new KeyboardInputCallback<String>(){

            public void onOk(String value) {
                SettingsTabContribution.this.settingsTabView.setDefaultIp(value);
                SettingsTabContribution.this.setBridgeIP(value);
                try {
                    if (new XMLRPCClient().connect(value, 1502).booleanValue()) {
                        Bridge bridgeSettings = SettingsTabContribution.this.getBridgeSettings();
                        Tool toolSettings = SettingsTabContribution.this.getToolSettings();
                        SettingsTabContribution.this.settingsTabView.setLblBridgeSoftwareVersion(SettingsTabContribution.this.getTextResource().bridgeSoftwareVersionInstallationSetting() + bridgeSettings.softwareVersion);
                        SettingsTabContribution.this.settingsTabView.setLblToolFirmwareVersion(SettingsTabContribution.this.getTextResource().toolFirmwareVersionInstallationSetting() + toolSettings.firmwareVersion);
                        SettingsTabContribution.this.settingsTabView.setLblBridgeSerialNumber(SettingsTabContribution.this.getTextResource().installationSettingBridgeSerialNumber() + bridgeSettings.serialNumber);
                        SettingsTabContribution.this.settingsTabView.setLblToolSerialNumber(SettingsTabContribution.this.getTextResource().installationSettingToolSerialNumber() + toolSettings.serialNumber);
                        SettingsTabContribution.this.settingsTabView.setLblSDName(SettingsTabContribution.this.getTextResource().installationSettingTool() + SettingsTabContribution.this.getToolName(toolSettings.serialNumber));
                        SettingsTabContribution.this.settingsTabView.setLblLEDSlider(SettingsTabContribution.this.getTextResource().installationSettingLEDLabel());
                        SettingsTabContribution.this.settingsTabView.setLblBuzzer(SettingsTabContribution.this.getTextResource().installationSettingBuzzerLabel());
                    } else {
                        PopupTool.showDialogWarning(new XMLRPCClient().getConnectionError(), SettingsTabContribution.this.getTextResource().connectionError());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }
}

