/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.hidden_nodes.move_direction;

import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionData;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionInterface;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionScriptGenerator;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionText;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionView;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveDirectionContribution
implements ProgramNodeContribution,
MoveDirectionInterface {
    @NotNull
    private final MoveDirectionView view;
    @NotNull
    private final MoveDirectionData data;
    @NotNull
    private final MoveDirectionScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UnitKeypadFactory unitKeypadFactory;

    MoveDirectionContribution(@NotNull MoveDirectionView view, @NotNull MoveDirectionData data, @NotNull MoveDirectionScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.unitKeypadFactory = apiProvider.getUnitKeypadFactory();
        view.setUnitConverter(apiProvider.getUnitConverter());
    }

    public void openView() {
        this.view.setMoveDistanceField(this.data.getMoveDistance());
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(MoveDirectionText.MOVE_DIRECTION);
    }

    public boolean isDefined() {
        return this.data.getMoveDistance() != null;
    }

    public void generateScript(ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.data);
    }

    @Override
    public void setMoveDistance(@NotNull Length distance) {
        this.data.setMoveDistance(distance);
    }

    @NotNull
    UnitKeypad<Integer, Length> getMoveDistanceIntegerKeypad(@Nullable Length initialLength) {
        UnitKeypad<Integer, Length> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        return keypad;
    }

    @NotNull
    UnitKeypad<Double, Length> getMoveDistanceDoubleKeypad(@Nullable Length initialLength) {
        UnitKeypad<Double, Length> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        return keypad;
    }
}

