/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.attach_bit;

import com.spin.core.program_node.attach_bit.AttachBitData;
import com.spin.core.program_node.attach_bit.AttachBitText;
import com.spin.domain.BitChangingStation;
import com.spin.i18n.TextResource;
import com.spin.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AttachBitScriptGenerator {
    void generateScript(@NotNull ScriptWriter writer, @NotNull TextResource textResource, @NotNull AttachBitData data) {
        BitChangingStation.Bit bit = data.selectedBit();
        BitChangingStation station = data.selectedStation();
        Pose bitPose = station.poseOf(bit);
        Pose poseInFront = station.poseInFrontOf(bit);
        InputStream attachBitScript = Objects.requireNonNull(this.getClass().getResourceAsStream("AttachBit.script"));
        ScriptParser parser = new ScriptParser(writer);
        parser.parseToScript(attachBitScript, this.poseToScriptString(bitPose), this.poseToScriptString(poseInFront), "\"" + textResource.load(AttachBitText.ERROR_MESSAGE) + "\"", "\"" + textResource.load(AttachBitText.ERROR_TITLE) + "\"", this.boolToString(data.approachEnabled()), this.boolToString(data.departEnabled()));
    }

    private String poseToScriptString(@NotNull Pose pose) {
        double[] values = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        assert (values.length == 6);
        return String.format("p[%f, %f, %f, %f, %f, %f]", values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    private String boolToString(@NotNull Boolean bool) {
        return bool != false ? "True" : "False";
    }
}

