/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.screw_feeder;

import com.spin.api.ExtendedInstallationAPIProvider;
import com.spin.core.installation_node.screw_feeder.ScrewFeederData;
import com.spin.core.installation_node.screw_feeder.ScrewFeederText;
import com.spin.core.installation_node.screw_feeder.ScrewFeederView;
import com.spin.domain.ScrewFeeder;
import com.spin.i18n.TextResource;
import com.spin.ui.component.keyboard.NameValidator;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.ui.component.keypad.UnitRangeValidator;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrewFeederContribution
implements InstallationNodeContribution {
    @NotNull
    private final ScrewFeederView view;
    @NotNull
    private final ScrewFeederData data;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final UnitKeypadFactory unitKeypadFactory;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private ScrewFeederView.Panel panelToReturnTo = ScrewFeederView.Panel.DETAILS;

    public ScrewFeederContribution(@NotNull ScrewFeederView view, @NotNull ScrewFeederData data, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.userInteraction = apiProvider.getInstallationAPIProvider().getUserInterfaceAPI().getUserInteraction();
        this.unitKeypadFactory = apiProvider.getUnitKeypadFactory();
        this.textResource = apiProvider.getTextResource();
        UnitConverter unitConverter = apiProvider.getUnitConverter();
        view.getDetailsView().setUnitConverter(unitConverter);
        view.getEditView().setUnitConverter(unitConverter);
        view.getDetailsView().setFeeders(data.screwFeeders());
        view.setActivePanel(ScrewFeederView.Panel.DETAILS);
    }

    public void openView() {
    }

    public void closeView() {
    }

    public void generateScript(ScriptWriter writer) {
    }

    void onAddNewFeeder() {
        this.view.getEditView().clearFeeder();
        this.view.setActivePanel(ScrewFeederView.Panel.EDIT_FEEDER);
    }

    void onEditExistingFeeder(@NotNull ScrewFeeder feeder) {
        this.view.getEditView().setFeeder(feeder);
        this.view.setActivePanel(ScrewFeederView.Panel.EDIT_FEEDER);
    }

    void onExitEditFeeder() {
        this.view.setActivePanel(ScrewFeederView.Panel.DETAILS);
    }

    void onVerifyNewPosition(@NotNull Pose screwPose) {
        this.panelToReturnTo = ScrewFeederView.Panel.EDIT_FEEDER;
        this.configureVerifyView(screwPose);
    }

    void onVerifyExistingPosition(@NotNull Pose screwPose) {
        this.panelToReturnTo = ScrewFeederView.Panel.DETAILS;
        this.configureVerifyView(screwPose);
    }

    private void configureVerifyView(@NotNull Pose screwPose) {
        Pose aboveScrewPose = this.data.calculateAboveScrewPose(screwPose);
        this.view.getVerifyPositionView().resetWithPoses(aboveScrewPose, screwPose);
        this.view.setActivePanel(ScrewFeederView.Panel.VERIFY_POSITION);
    }

    void onExitVerifyPosition() {
        this.view.setActivePanel(this.panelToReturnTo);
    }

    void storeFeeder(@NotNull ScrewFeeder feeder) {
        this.data.storeScrewFeeder(feeder);
        this.view.getDetailsView().setFeeders(this.data.screwFeeders());
        this.view.getDetailsView().selectFeederByID(feeder.id());
    }

    void removeFeeder(@NotNull ScrewFeeder feeder) {
        this.data.removeScrewFeeder(feeder);
        this.view.getDetailsView().setFeeders(this.data.screwFeeders());
    }

    @NotNull
    KeyboardTextInput getFeederNameKeyboard(@Nullable String initialName) {
        Collection disallowedNames = this.data.screwFeeders().stream().map(ScrewFeeder::name).filter(name -> !name.equals(initialName)).collect(Collectors.toSet());
        String helpMessage = this.textResource.load(ScrewFeederText.NAME_IN_USE_HELP_TEXT);
        KeyboardTextInput keyboard = this.userInteraction.getKeyboardInputFactory().createStringKeyboardInput();
        keyboard.setInitialValue(initialName);
        keyboard.setErrorValidator((InputValidator)new NameValidator(disallowedNames, helpMessage));
        return keyboard;
    }

    @NotNull
    UnitKeypad<Integer, Length> getScrewLengthIntegerKeypad(@Nullable Length initialLength) {
        UnitKeypad<Integer, Length> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Length.class);
        keypad.setInitialValue(initialLength);
        keypad.setErrorValidator(this.unitKeypadFactory.createIntegerRangeValidator(Length.class, this.data.minAllowedScrewLength(), this.data.maxAllowedScrewLength()));
        return keypad;
    }

    @NotNull
    UnitKeypad<Double, Length> getScrewLengthDoubleKeypad(@Nullable Length initialLength) {
        UnitKeypad<Double, Length> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Length.class);
        UnitRangeValidator<Double, Length> validator = this.unitKeypadFactory.createDoubleRangeValidator(Length.class, this.data.minAllowedScrewLength(), this.data.maxAllowedScrewLength());
        keypad.setInitialValue(initialLength);
        keypad.setErrorValidator(validator);
        return keypad;
    }

    @NotNull
    UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @NotNull
    public Set<ScrewFeeder> getScrewFeeders() {
        return this.data.screwFeeders();
    }
}

