/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpinLog {
    @Nullable
    private static File logFile = null;

    public static void setLogFile(@NotNull File file) {
        if (logFile != null) {
            throw new IllegalStateException("Log file must only be set once");
        }
        logFile = file;
    }

    public static void print(@NotNull String text) {
        if (logFile != null) {
            SpinLog.writeToFile(logFile, text);
        }
    }

    private static synchronized void writeToFile(@NotNull File file, @NotNull String text) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file, true));
            writer.append(String.format("%-25s %s\n", new Timestamp(System.currentTimeMillis()), text));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

