/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bit_changing_station;

import com.spin.core.installation_node.bit_changing_station.BitChangingStationContribution;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationText;
import com.spin.ui.callback.OnMovementCompleteCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VerifyStationPositionView {
    @NotNull
    private final JButton moveAboveBButton;
    @NotNull
    private final JButton moveToBButton;
    @NotNull
    private final JButton cancelButton;
    @Nullable
    private Pose aboveBPose = null;
    @Nullable
    private Pose atBPose = null;

    VerifyStationPositionView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        ImageIcon moveIcon = UR_Icon.MOVE.load();
        ImageIcon cancelIcon = UR_Icon.CANCEL.load();
        this.moveAboveBButton = new ButtonMedium(textResource.load(BitChangingStationText.MOVE_ABOVE_B), moveIcon);
        this.moveToBButton = new ButtonMedium(textResource.load(BitChangingStationText.MOVE_TO_B), moveIcon);
        this.cancelButton = new ButtonMedium(textResource.load(BitChangingStationText.CANCEL), cancelIcon);
    }

    @NotNull
    JPanel createLeftPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(6, 20, "push[]10[]push[]push"));
        panel.add((Component)this.moveAboveBButton, "cell 1 0, span 4, grow");
        panel.add((Component)this.moveToBButton, "cell 1 1, span 4, grow");
        panel.add((Component)this.cancelButton, "cell 2 2, span 2, grow");
        return panel;
    }

    @NotNull
    JPanel createRightPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.singleColumn(20, "[grow]"));
        Dimension imageSize = new Dimension(500, -1);
        ImagePanel imagePanel = new ImagePanel(SpinImage.BIT_CHANGING_STATION_POINT_B.load(imageSize));
        panel.add((Component)imagePanel, "right");
        return panel;
    }

    void registerListeners(@NotNull BitChangingStationContribution contribution) {
        this.moveAboveBButton.addActionListener(event -> this.moveAboveB(contribution));
        this.moveToBButton.addActionListener(event -> this.moveToB(contribution));
        this.cancelButton.addActionListener(event -> contribution.onExitVerifyPosition());
    }

    void resetWithPoses(@NotNull Pose aboveBPose, @NotNull Pose atBPose) {
        this.aboveBPose = aboveBPose;
        this.atBPose = atBPose;
        this.moveToBButton.setEnabled(false);
    }

    private void moveAboveB(@NotNull BitChangingStationContribution contribution) {
        assert (this.aboveBPose != null);
        RobotMovement robotMovement = contribution.getUserInteraction().getRobotMovement();
        robotMovement.requestUserToMoveRobot(this.aboveBPose, (RobotMovementCallback)new OnMovementCompleteCallback(() -> this.moveToBButton.setEnabled(true)));
    }

    private void moveToB(@NotNull BitChangingStationContribution contribution) {
        assert (this.atBPose != null);
        RobotMovement robotMovement = contribution.getUserInteraction().getRobotMovement();
        robotMovement.requestUserToMoveRobot(this.atBPose, (RobotMovementCallback)new OnMovementCompleteCallback(contribution::onExitVerifyPosition));
    }
}

