/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy.monitorer;

import com.spin.bridge_communication.proxy.monitorer.HeartbeatHandler;
import com.spin.bridge_communication.proxy.monitorer.StateHandler;
import com.spin.bridge_communication.proxy.state_machine.Monitorer;
import com.spin.bridge_communication.proxy.xmlrpc_client.XmlRpcBridgeClient;
import com.spin.domain.MonitoredItems;
import com.spin.util.SpinLog;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRpcMonitorer
implements Monitorer {
    private static final long initialSchedulingDelay_ms = 1000L;
    private static final long schedulingPeriod_ms = 50L;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final XmlRpcBridgeClient bridgeClient;
    @NotNull
    private final HeartbeatHandler heartbeatHandler;
    @NotNull
    private final StateHandler stateHandler;
    @Nullable
    private ScheduledFuture<?> monitorTask = null;
    private boolean monitorHeartbeatIsScheduled = false;
    private boolean monitorEverythingIsScheduled = false;
    private Runnable xmlRpcExceptionCallback = () -> SpinLog.print("No xmlRpcException callback has been set");

    public XmlRpcMonitorer(@NotNull ScheduledExecutorService executor, @NotNull XmlRpcBridgeClient bridgeClient, @NotNull HeartbeatHandler heartbeatHandler, @NotNull StateHandler stateHandler) {
        this.executor = executor;
        this.bridgeClient = bridgeClient;
        this.heartbeatHandler = heartbeatHandler;
        this.stateHandler = stateHandler;
    }

    public void setXmlRpcExceptionCallback(@NotNull Runnable callback) {
        this.xmlRpcExceptionCallback = callback;
    }

    @Override
    public void monitorHeartbeat() {
        this.monitorTask = this.executor.scheduleAtFixedRate(this::monitorItems, 1000L, 50L, TimeUnit.MILLISECONDS);
        this.monitorHeartbeatIsScheduled = true;
    }

    @Override
    public void monitorEverything() {
        if (!this.monitorHeartbeatIsScheduled) {
            throw new IllegalStateException("monitorHeartbeat has not been called");
        }
        this.monitorEverythingIsScheduled = true;
        this.onBridgeConnected();
    }

    @Override
    public void stopMonitoring() {
        assert (this.monitorTask != null);
        this.monitorTask.cancel(false);
        if (this.monitorEverythingIsScheduled) {
            this.stateHandler.handleBridgeDisconnected();
        }
        this.stateHandler.reset();
        this.monitorHeartbeatIsScheduled = false;
        this.monitorEverythingIsScheduled = false;
    }

    private void onBridgeConnected() {
        try {
            this.stateHandler.handleBridgeConnected();
        }
        catch (XmlRpcException e) {
            SpinLog.print("XmlRpcException during onBridgeConnected: " + e.getMessage());
            this.xmlRpcExceptionCallback.run();
        }
    }

    private void monitorItems() {
        try {
            this.fetchAndProcessMonitoredItems();
        }
        catch (XmlRpcException e) {
            SpinLog.print("fetchAndProcess monitored items failed: " + e.getMessage());
            this.xmlRpcExceptionCallback.run();
        }
    }

    private void fetchAndProcessMonitoredItems() throws XmlRpcException {
        MonitoredItems monitoredItems = this.bridgeClient.monitorItems();
        this.heartbeatHandler.handleHeartbeat(monitoredItems);
        if (this.monitorEverythingIsScheduled) {
            this.stateHandler.handleMonitoredState(monitoredItems);
        }
    }
}

