/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.xmlrpc;

import com.spin.urcap.impl.installation_node.settings.UDPMulticastClient;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.program_nodes.toolbar.GuideToolbarContribution;
import com.spin.urcap.impl.util.Bridge;
import com.spin.urcap.impl.util.Product;
import com.spin.urcap.impl.util.ScrewProgram;
import com.spin.urcap.impl.util.ScrewProgramLog;
import com.spin.urcap.impl.util.Tool;
import de.re.easymodbus.modbusclient.ModbusClient;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class BridgeModbusClient {
    private static final int MAX_READ_LENGTH = 125;
    private static ModbusClient modbusClient = null;
    private static final ReentrantLock mutex = new ReentrantLock();
    private static final Bridge bridge = new Bridge();
    private static final Tool tool = new Tool();
    private final String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
    private static String connectionError;

    public String getTitle() {
        return "XMLRPC-server";
    }

    public String getIp() {
        mutex.lock();
        try {
            String string = modbusClient.getipAddress();
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDHCP() {
        mutex.lock();
        try {
            String IP = UDPMulticastClient.getLocalHostLANAddress().getHostAddress();
            System.out.println("UR IP Address: " + IP);
            String ip = "230.0.0.0";
            int port = 9434;
            String msg = "spin_ip_broadcast_cl," + IP;
            UDPMulticastClient UDPCLient = new UDPMulticastClient();
            UDPCLient.sendUDPMessage(msg, ip, port);
            String string = UDPCLient.receiveUDPMessage(ip, port);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String ip, int port) {
        mutex.lock();
        try {
            InetAddress address;
            boolean reachable;
            if (modbusClient != null) {
                modbusClient.Disconnect();
            }
            if (reachable = (address = InetAddress.getByName(ip)).isReachable(1000)) {
                modbusClient = new ModbusClient(ip, port);
                System.out.println(this.className + ": Modbus client created. Modbus server info: " + ip + ":" + port);
                modbusClient.Connect();
                System.out.println(this.className + ": Modbus client connected to server!");
                this.handleConnected(true);
                new GuideToolbarContribution().setNewConnection(true);
                boolean bl = true;
                return bl;
            }
            connectionError = this.className + ": Modbus client host: " + ip + " is not reachable";
            System.out.println(connectionError);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            connectionError = this.className + ": Could not connect to Modbus server! " + e.getLocalizedMessage();
            System.out.println(connectionError);
        }
        finally {
            mutex.unlock();
        }
        return false;
    }

    public void disconnect() {
        try {
            if (this.isConnected()) {
                modbusClient.Disconnect();
                modbusClient = null;
                System.out.println(this.className + ": Disconnected!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return modbusClient != null;
    }

    public boolean ping() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = modbusClient.ReadInputRegisters(0, 1)[0] < 101;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleConnected(boolean onConnected) {
        mutex.lock();
        try {
            int REG_FIRST = 10;
            int REG_LAST = 53;
            int DATA_LENGTH = 44;
            int[] data = modbusClient.ReadInputRegisters(10, 44);
            int tvTool = data[2];
            int versionTool = tvTool % 10;
            int typeTool = (tvTool - versionTool) / 10;
            BridgeModbusClient.tool.serialNumber = String.format("%02d", data[0]) + String.format("%02d", data[1]) + typeTool + versionTool + String.format("%02d", data[3]) + String.format("%04d", data[4]);
            BridgeModbusClient.tool.firmwareVersion = data[5] + "." + data[6] + "." + data[7];
            int tvBridge = data[12];
            int versionBridge = tvBridge % 10;
            int typeBridge = (tvBridge - versionBridge) / 10;
            BridgeModbusClient.bridge.serialNumber = String.format("%02d", data[10]) + String.format("%02d", data[11]) + typeBridge + versionBridge + String.format("%02d", data[13]) + String.format("%04d", data[14]);
            BridgeModbusClient.bridge.softwareVersion = data[15] + "." + data[16] + "." + data[17];
            BridgeModbusClient.tool.motor.minSpeed = data[30];
            BridgeModbusClient.tool.motor.maxSpeed = data[31];
            BridgeModbusClient.tool.motor.minTorque = (double)data[32] / 1000.0;
            BridgeModbusClient.tool.motor.maxTorque = (double)data[33] / 1000.0;
            BridgeModbusClient.tool.safetyShield.minSpeed = (double)data[40] / 100.0 * 0.001;
            BridgeModbusClient.tool.safetyShield.maxSpeed = (double)data[41] / 100.0 * 0.001;
            BridgeModbusClient.tool.safetyShield.minLimit = (double)data[42] / 100.0 * 0.001;
            BridgeModbusClient.tool.safetyShield.maxLimit = (double)data[43] / 100.0 * 0.001;
            if (onConnected) {
                System.out.println(this.className + ": Saved bridge and tool: " + bridge + " " + tool);
            } else if (this.getToolConnection()) {
                System.out.println(this.className + ": Saved bridge and tool: " + bridge + " " + tool);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    @Nullable
    public int[] getToolStatus() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int[] nArray = null;
                return nArray;
            }
            int[] nArray = modbusClient.ReadInputRegisters(1700, 3);
            return nArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] nArray = null;
            return nArray;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolBuzzerIntensity() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int n = -1;
                return n;
            }
            int n = modbusClient.ReadInputRegisters(0, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolLedIntensity() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int n = -1;
                return n;
            }
            int n = modbusClient.ReadInputRegisters(1, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public String getConnectionError() {
        return connectionError;
    }

    public Tool getTool() {
        return tool;
    }

    public int getToolMotorMinSpeed() {
        return this.getTool().motor.minSpeed;
    }

    public int getToolMotorMaxSpeed() {
        return this.getTool().motor.maxSpeed;
    }

    public double getToolMotorMinTorque() {
        return this.getTool().motor.minTorque;
    }

    public double getToolMotorMaxTorque() {
        return this.getTool().motor.maxTorque;
    }

    public double getToolSafetyShieldMinSpeed() {
        return this.getTool().safetyShield.minSpeed;
    }

    public double getToolSafetyShieldMaxSpeed() {
        return this.getTool().safetyShield.maxSpeed;
    }

    public double getToolSafetyShieldMinLimit() {
        return this.getTool().safetyShield.minLimit;
    }

    public double getToolSafetyShieldMaxLimit() {
        return this.getTool().safetyShield.maxLimit;
    }

    public Bridge getBridge() {
        return bridge;
    }

    public boolean getToolConnection() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = modbusClient.ReadInputRegisters(60, 1)[0] == 1;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolScrewState() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int n = -1;
                return n;
            }
            int n = modbusClient.ReadInputRegisters(61, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolSafetyShieldState() {
        mutex.lock();
        try {
            int n = modbusClient.ReadInputRegisters(62, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getToolSafetyShieldPosition() {
        mutex.lock();
        try {
            double d = (double)modbusClient.ReadInputRegisters(63, 1)[0] / 100.0 * 0.001;
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            double d = -1.0;
            return d;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean getToolButton1State() {
        mutex.lock();
        try {
            boolean bl = modbusClient.ReadInputRegisters(64, 1)[0] == 1;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean getToolButton2State() {
        mutex.lock();
        try {
            boolean bl = modbusClient.ReadInputRegisters(65, 1)[0] == 1;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getToolScrewDetectionValue() {
        mutex.lock();
        try {
            int n = modbusClient.ReadInputRegisters(66, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean getBridgeRobotInterfaceConnection() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = modbusClient.ReadInputRegisters(80, 1)[0] == 1;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getBridgeScrewProcessState() {
        mutex.lock();
        try {
            int n = modbusClient.ReadInputRegisters(81, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public int[] getBridgeError() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int length = modbusClient.ReadInputRegisters(82, 1)[0];
            if (length == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int[] nArray = modbusClient.ReadInputRegisters(83, length);
            return nArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getBridgeErrorLength() {
        return this.getBridgeError().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBridgeErrorString() {
        int[] errors = this.getBridgeError();
        mutex.lock();
        try {
            String[] errorsString = new String[errors.length];
            ErrorMessages errorMessages = new ErrorMessages();
            for (int i = 0; i < errors.length; ++i) {
                errorsString[i] = errors[i] < errorMessages.errorCodes.length ? errorMessages.errorCodes[errors[i]] : "Unknown error!";
            }
            String[] stringArray = errorsString;
            return stringArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBridgeErrorStringConcatenated() {
        String[] stringList = this.getBridgeErrorString();
        mutex.lock();
        try {
            StringBuilder str = new StringBuilder();
            for (String s : stringList) {
                str.append(s).append(" ");
            }
            String string = str.toString().isEmpty() ? "No errors!" : str.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            String string = "";
            return string;
        }
        finally {
            mutex.unlock();
        }
    }

    public int[] getProductIds() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int length = modbusClient.ReadInputRegisters(100, 1)[0];
            if (length == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int[] nArray = modbusClient.ReadInputRegisters(101, length);
            return nArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProduct() {
        mutex.lock();
        Product product = new Product();
        product.id = -1;
        try {
            int screwProgramIdLength;
            if (!this.isConnected()) {
                Product product2 = product;
                return product2;
            }
            int REG_FIRST = 210;
            int REG_LAST = 211;
            int DATA_LENGTH = 2;
            int[] data = modbusClient.ReadInputRegisters(210, 2);
            product.id = data[0];
            product.name = "";
            int nameLength = data[1];
            if (0 < nameLength) {
                int[] name = modbusClient.ReadInputRegisters(212, nameLength);
                StringBuilder sb = new StringBuilder();
                for (int n : name) {
                    sb.append((char)n);
                }
                product.name = sb.toString();
            }
            if (0 < (screwProgramIdLength = modbusClient.ReadInputRegisters(312, 1)[0])) {
                product.screwProgramIds = modbusClient.ReadInputRegisters(313, screwProgramIdLength);
            }
            Product product3 = product;
            return product3;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            Product product4 = product;
            return product4;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrewProgram getScrewProgram() {
        mutex.lock();
        ScrewProgram screwProgram = new ScrewProgram();
        screwProgram.id = -1;
        try {
            if (!this.isConnected()) {
                ScrewProgram screwProgram2 = screwProgram;
                return screwProgram2;
            }
            int REG_FIRST = 420;
            int REG_LAST = 432;
            int DATA_LENGTH = 13;
            int[] data = modbusClient.ReadInputRegisters(420, 13);
            screwProgram.id = data[0];
            screwProgram.direction = data[1];
            screwProgram.typeId = data[9];
            screwProgram.parentId = data[10];
            screwProgram.childId = data[11];
            screwProgram.screw.length = (double)data[2] / 100.0 * 0.001;
            screwProgram.screw.typeId = data[3];
            screwProgram.screw.washerThickness = (double)data[4] / 100.0 * 0.001;
            screwProgram.targetAngle = (double)data[5] / 100.0;
            screwProgram.targetPosition = (double)data[6] / 100.0 * 0.001;
            screwProgram.targetTorque = (double)data[7] / 1000.0;
            screwProgram.targetDev = (double)data[8] / 100.0;
            screwProgram.name = "";
            int nameLength = data[12];
            if (0 < nameLength) {
                int[] name = modbusClient.ReadInputRegisters(433, nameLength);
                StringBuilder sb = new StringBuilder();
                for (int n : name) {
                    sb.append((char)n);
                }
                screwProgram.name = screwProgram.name + sb.toString();
            }
            ScrewProgram screwProgram3 = screwProgram;
            return screwProgram3;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            ScrewProgram screwProgram4 = screwProgram;
            return screwProgram4;
        }
        finally {
            mutex.unlock();
        }
    }

    public int getScrewProgramLogId() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                int n = -1;
                return n;
            }
            int n = modbusClient.ReadInputRegisters(540, 1)[0];
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            int n = -1;
            return n;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean getBridgeHeartbeat() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                return false;
            }
            return modbusClient.ReadInputRegisters(1700, 1)[0] > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrewProgramLog getScrewProgramLog() {
        mutex.lock();
        ScrewProgramLog screwProgramLog = new ScrewProgramLog();
        screwProgramLog.id = -1;
        try {
            if (!this.isConnected()) {
                ScrewProgramLog screwProgramLog2 = screwProgramLog;
                return screwProgramLog2;
            }
            int REG_FIRST = 540;
            int REG_LAST = 555;
            int DATA_LENGTH = 16;
            int[] data = modbusClient.ReadInputRegisters(540, 16);
            screwProgramLog.id = data[0];
            int t1 = data[2];
            int t2 = data[3];
            int t3 = data[4];
            int t4 = data[5];
            screwProgramLog.timestamp = (long)t4 << 48 | (long)t3 << 32 | (long)t2 << 16 | (long)(t1 & 0xFFFF);
            screwProgramLog.success = data[1] == 1;
            screwProgramLog.typeId = data[6];
            screwProgramLog.targetAngle = (double)data[7] / 100.0;
            screwProgramLog.targetPosition = (double)data[8] / 100.0 * 0.001;
            screwProgramLog.targetTorque = (double)data[9] / 1000.0;
            screwProgramLog.targetDev = (double)data[10] / 100.0;
            screwProgramLog.finalAngle = (double)data[11] / 100.0;
            screwProgramLog.finalPosition = (double)data[12] / 100.0 * 0.001;
            screwProgramLog.finalTorque = (double)data[13] / 1000.0;
            screwProgramLog.sampleRate = data[14];
            int torqueLogLength = modbusClient.ReadInputRegisters(555, 1)[0];
            if (torqueLogLength != 0) {
                int batches = (int)Math.ceil((float)torqueLogLength / 125.0f);
                int remainder = torqueLogLength % 125;
                double[] resArray = new double[torqueLogLength];
                ArrayList<Double> resArrayList = new ArrayList<Double>();
                for (int counter = batches; counter > 0; --counter) {
                    int address = 556 + (batches - counter) * 125;
                    int dataLength = counter == 1 && remainder != 0 ? remainder : 125;
                    int[] torqueDataArray = modbusClient.ReadInputRegisters(address, dataLength);
                    for (int i = 0; i < dataLength; ++i) {
                        resArrayList.add((double)torqueDataArray[i] / 1000.0);
                    }
                }
                for (int i = 0; i < torqueLogLength; ++i) {
                    resArray[i] = (Double)resArrayList.get(i);
                }
                screwProgramLog.torqueLog = resArray;
            }
            ScrewProgramLog screwProgramLog3 = screwProgramLog;
            return screwProgramLog3;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            ScrewProgramLog screwProgramLog4 = screwProgramLog;
            return screwProgramLog4;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setToolBuzzerIntensity(int data) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            int[] dataArray = new int[]{0, data};
            modbusClient.WriteMultipleRegisters(0, dataArray);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setToolLedIntensity(int data) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            int[] dataArray = new int[]{1, data};
            modbusClient.WriteMultipleRegisters(0, dataArray);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setGetProduct(int data) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            modbusClient.WriteSingleRegister(5, data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setGetScrewProgram(int data) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            modbusClient.WriteSingleRegister(6, data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public Boolean setResetErrors() {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                Boolean bl = false;
                return bl;
            }
            modbusClient.WriteSingleRegister(10, 1);
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            Boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSafetyShieldCommand(int command, double position, double speed) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            int[] data = new int[]{command, (int)(position * 1000.0 * 100.0), (int)(speed * 1000.0 * 100.0)};
            modbusClient.WriteMultipleRegisters(20, data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSafetyShieldCommandMaxSped(int command, double position) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            int[] data = new int[]{command, (int)(position * 1000.0 * 100.0), (int)(this.getToolSafetyShieldMaxSpeed() * 1000.0 * 100.0)};
            modbusClient.WriteMultipleRegisters(20, data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScrewCommand(int command, int direction, int speed) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            int[] data = new int[]{command, direction, speed};
            modbusClient.WriteMultipleRegisters(30, data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    public boolean setScrewCommandMinSpeedScaled(int command, int direction, double scale) {
        return this.setScrewCommand(command, direction, (int)((double)this.getToolMotorMinSpeed() * scale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScrewProgramCommand(int command, int id, double robotStartOffset) {
        mutex.lock();
        try {
            if (!this.isConnected()) {
                boolean bl = false;
                return bl;
            }
            int[] data = new int[]{command, id, (int)(robotStartOffset * 1000.0 * 100.0)};
            modbusClient.WriteMultipleRegisters(40, data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            boolean bl = false;
            return bl;
        }
        finally {
            mutex.unlock();
        }
    }

    private static class ErrorMessages {
        public final String[] errorCodes = new String[250];

        public ErrorMessages() {
            TextResource textResource = LanguagePack.getTextResource();
            Arrays.fill(this.errorCodes, "Empty error!");
            this.errorCodes[10] = textResource.error10();
            this.errorCodes[11] = textResource.error11();
            this.errorCodes[12] = textResource.error12();
            this.errorCodes[13] = textResource.error13();
            this.errorCodes[14] = textResource.error14();
            this.errorCodes[50] = textResource.error50();
            this.errorCodes[60] = textResource.error60();
            this.errorCodes[61] = textResource.error61();
            this.errorCodes[62] = textResource.error62();
            this.errorCodes[63] = textResource.error63();
            this.errorCodes[64] = textResource.error64();
            this.errorCodes[65] = textResource.error65();
            this.errorCodes[66] = textResource.error66();
            this.errorCodes[80] = textResource.error80();
            this.errorCodes[81] = textResource.error81();
            this.errorCodes[82] = textResource.error82();
            this.errorCodes[83] = textResource.error83();
            this.errorCodes[84] = textResource.error84();
            this.errorCodes[85] = textResource.error85();
            this.errorCodes[86] = textResource.error86();
            this.errorCodes[87] = textResource.error87();
            this.errorCodes[88] = textResource.error88();
            this.errorCodes[89] = textResource.error89();
            this.errorCodes[90] = textResource.error90();
            this.errorCodes[91] = textResource.error91();
            this.errorCodes[92] = textResource.error92();
            this.errorCodes[93] = textResource.error93();
            this.errorCodes[94] = textResource.error94();
            this.errorCodes[100] = textResource.error100();
            this.errorCodes[101] = textResource.error101();
            this.errorCodes[102] = textResource.error102();
            this.errorCodes[103] = textResource.error103();
            this.errorCodes[104] = textResource.error104();
            this.errorCodes[105] = textResource.error105();
            this.errorCodes[106] = textResource.error106();
            this.errorCodes[107] = textResource.error107();
            this.errorCodes[108] = textResource.error108();
            this.errorCodes[109] = textResource.error109();
            this.errorCodes[110] = textResource.error110();
            this.errorCodes[111] = textResource.error111();
            this.errorCodes[112] = textResource.error112();
            this.errorCodes[113] = textResource.error113();
            this.errorCodes[114] = textResource.error114();
            this.errorCodes[115] = textResource.error115();
            this.errorCodes[116] = textResource.error116();
            this.errorCodes[130] = textResource.error130();
            this.errorCodes[131] = textResource.error131();
            this.errorCodes[132] = textResource.error132();
            this.errorCodes[133] = textResource.error133();
            this.errorCodes[134] = textResource.error134();
            this.errorCodes[135] = textResource.error135();
            this.errorCodes[150] = textResource.error150();
            this.errorCodes[151] = textResource.error151();
            this.errorCodes[152] = textResource.error152();
            this.errorCodes[153] = textResource.error153();
            this.errorCodes[154] = textResource.error154();
            this.errorCodes[155] = textResource.error155();
            this.errorCodes[156] = textResource.error156();
            this.errorCodes[157] = textResource.error157();
            this.errorCodes[158] = textResource.error158();
            this.errorCodes[159] = textResource.error159();
            this.errorCodes[160] = textResource.error160();
            this.errorCodes[161] = textResource.error161();
            this.errorCodes[162] = textResource.error162();
            this.errorCodes[163] = textResource.error163();
            this.errorCodes[164] = textResource.error164();
            this.errorCodes[165] = textResource.error165();
            this.errorCodes[166] = textResource.error166();
            this.errorCodes[167] = textResource.error167();
            this.errorCodes[168] = textResource.error168();
            this.errorCodes[169] = textResource.error169();
            this.errorCodes[170] = textResource.error170();
            this.errorCodes[171] = textResource.error171();
            this.errorCodes[172] = textResource.error172();
            this.errorCodes[173] = textResource.error173();
        }
    }

    private static class RegHolMap {
        private static final int SET_IN_REG_ADDRESS = 0;
        private static final int SET_IN_REG_VALUE = 1;
        private static final int GET_PRODUCT = 5;
        private static final int GET_SCREW_PROGRAM = 6;
        private static final int RESET_ERRORS = 10;
        private static final int SAFETY_SHIELD_COMMAND = 20;
        private static final int SAFETY_SHIELD_POSITION = 21;
        private static final int SAFETY_SHIELD_SPEED = 22;
        private static final int SCREW_COMMAND = 30;
        private static final int SCREW_DIRECTION = 31;
        private static final int SCREW_SPEED = 32;
        private static final int SCREW_PROGRAM_COMMAND = 40;
        private static final int SCREW_PROGRAM_ID = 41;
        private static final int SCREW_PROGRAM_ROBOT_START_OFFSET = 42;

        private RegHolMap() {
        }
    }

    private static class RegInMap {
        private static final int LENGTH_BRIDGE_ERROR_BUFFER = 10;
        private static final int LENGTH_DATABASE_PRODUCT_ID_BUFFER = 100;
        private static final int LENGTH_PRODUCT_NAME_BUFFER = 100;
        private static final int LENGTH_PRODUCT_SCREW_PROGRAM_ID_BUFFER = 100;
        private static final int LENGTH_SCREW_PROGRAM_NAME_BUFFER = 100;
        private static final int LENGTH_SCREW_PROGRAM_LOG_TORQUE_BUFFER = 1000;
        private static final int TOOL_BUZZER_INTENSITY = 0;
        private static final int TOOL_LED_INTENSITY = 1;
        private static final int TOOL_SERIAL_NUMBER_PP = 10;
        private static final int TOOL_SERIAL_NUMBER_MM = 11;
        private static final int TOOL_SERIAL_NUMBER_TV = 12;
        private static final int TOOL_SERIAL_NUMBER_YY = 13;
        private static final int TOOL_SERIAL_NUMBER_SSSS = 14;
        private static final int TOOL_FIRMWARE_MAJOR = 15;
        private static final int TOOL_FIRMWARE_MINOR = 16;
        private static final int TOOL_FIRMWARE_PATCH = 17;
        private static final int BRIDGE_SERIAL_NUMBER_PP = 20;
        private static final int BRIDGE_SERIAL_NUMBER_MM = 21;
        private static final int BRIDGE_SERIAL_NUMBER_TV = 22;
        private static final int BRIDGE_SERIAL_NUMBER_YY = 23;
        private static final int BRIDGE_SERIAL_NUMBER_SSSS = 24;
        private static final int BRIDGE_SOFTWARE_MAJOR = 25;
        private static final int BRIDGE_SOFTWARE_MINOR = 26;
        private static final int BRIDGE_SOFTWARE_PATCH = 27;
        private static final int TOOL_MOTOR_MIN_SPEED = 40;
        private static final int TOOL_MOTOR_MAX_SPEED = 41;
        private static final int TOOL_MOTOR_MIN_TORQUE = 42;
        private static final int TOOL_MOTOR_MAX_TORQUE = 43;
        private static final int TOOL_SAFETY_SHIELD_MIN_SPEED = 50;
        private static final int TOOL_SAFETY_SHIELD_MAX_SPEED = 51;
        private static final int TOOL_SAFETY_SHIELD_MIN_LIMIT = 52;
        private static final int TOOL_SAFETY_SHIELD_MAX_LIMIT = 53;
        private static final int TOOL_CONNECTION = 60;
        private static final int TOOL_SCREW_STATE = 61;
        private static final int TOOL_SAFETY_SHIELD_STATE = 62;
        private static final int TOOL_SAFETY_SHIELD_POSITION = 63;
        private static final int TOOL_BUTTON1_STATE = 64;
        private static final int TOOL_BUTTON2_STATE = 65;
        private static final int TOOL_SCREW_DETECTION_VALUE = 66;
        private static final int BRIDGE_ROBOT_INTERFACE_CONNECTION = 80;
        private static final int BRIDGE_SCREW_PROCESS_STATE = 81;
        private static final int BRIDGE_ERROR_BUFFER_LENGTH = 82;
        private static final int BRIDGE_ERROR_BUFFER_START = 83;
        private static final int BRIDGE_ERROR_BUFFER_END = 92;
        private static final int DATABASE_PRODUCT_ID_BUFFER_LENGTH = 100;
        private static final int DATABASE_PRODUCT_ID_BUFFER_START = 101;
        private static final int DATABASE_PRODUCT_ID_BUFFER_END = 200;
        private static final int PRODUCT_ID = 210;
        private static final int PRODUCT_NAME_BUFFER_LENGTH = 211;
        private static final int PRODUCT_NAME_BUFFER_START = 212;
        private static final int PRODUCT_NAME_BUFFER_END = 311;
        private static final int PRODUCT_SCREW_PROGRAM_ID_BUFFER_LENGTH = 312;
        private static final int PRODUCT_SCREW_PROGRAM_ID_BUFFER_START = 313;
        private static final int PRODUCT_SCREW_PROGRAM_ID_BUFFER_END = 412;
        private static final int SCREW_PROGRAM_ID = 420;
        private static final int SCREW_PROGRAM_DIRECTION = 421;
        private static final int SCREW_PROGRAM_SCREW_LENGTH = 422;
        private static final int SCREW_PROGRAM_SCREW_TYPE_ID = 423;
        private static final int SCREW_PROGRAM_SCREW_WASHER_THICKNESS = 424;
        private static final int SCREW_PROGRAM_TARGET_ANGLE = 425;
        private static final int SCREW_PROGRAM_TARGET_POSITION = 426;
        private static final int SCREW_PROGRAM_TARGET_TORQUE = 427;
        private static final int SCREW_PROGRAM_TARGET_DEV = 428;
        private static final int SCREW_PROGRAM_TYPE_ID = 429;
        private static final int SCREW_PROGRAM_PARENT_ID = 430;
        private static final int SCREW_PROGRAM_CHILD_ID = 431;
        private static final int SCREW_PROGRAM_NAME_BUFFER_LENGTH = 432;
        private static final int SCREW_PROGRAM_NAME_BUFFER_START = 433;
        private static final int SCREW_PROGRAM_NAME_BUFFER_END = 532;
        private static final int SCREW_PROGRAM_LOG_ID = 540;
        private static final int SCREW_PROGRAM_LOG_SUCCESS = 541;
        private static final int SCREW_PROGRAM_LOG_TIMESTAMP_1 = 542;
        private static final int SCREW_PROGRAM_LOG_TIMESTAMP_2 = 543;
        private static final int SCREW_PROGRAM_LOG_TIMESTAMP_3 = 544;
        private static final int SCREW_PROGRAM_LOG_TIMESTAMP_4 = 545;
        private static final int SCREW_PROGRAM_LOG_TYPE_ID = 546;
        private static final int SCREW_PROGRAM_LOG_TARGET_ANGLE = 547;
        private static final int SCREW_PROGRAM_LOG_TARGET_POSITION = 548;
        private static final int SCREW_PROGRAM_LOG_TARGET_TORQUE = 549;
        private static final int SCREW_PROGRAM_LOG_TARGET_DEV = 550;
        private static final int SCREW_PROGRAM_LOG_FINAL_ANGLE = 551;
        private static final int SCREW_PROGRAM_LOG_FINAL_POSITION = 552;
        private static final int SCREW_PROGRAM_LOG_FINAL_TORQUE = 553;
        private static final int SCREW_PROGRAM_LOG_SAMPLE_RATE = 554;
        private static final int SCREW_PROGRAM_LOG_TORQUE_BUFFER_LENGTH = 555;
        private static final int SCREW_PROGRAM_LOG_TORQUE_BUFFER_START = 556;
        private static final int SCREW_PROGRAM_LOG_TORQUE_BUFFER_END = 1555;
        private static final int BRIDGE_HEARTBEAT = 1700;
        private static final int FREEDRIVE = 1701;
        private static final int TOOL_CONNECTION_COPY = 1702;

        private RegInMap() {
        }
    }

    private static class ModbusScaleFactors {
        private static final double MODBUS_SCALE_FACTOR_MOTOR = 1000.0;
        private static final double MODBUS_SCALE_FACTOR_SAFETY_SHIELD = 100.0;
        private static final double MODBUS_SCALE_FACTOR_SCREW_PROGRAM_ANGLE = 100.0;
        private static final double MODBUS_SCALE_FACTOR_SCREW_PROGRAM_POSITION = 100.0;
        private static final double MODBUS_SCALE_FACTOR_SCREW_PROGRAM_TORQUE = 1000.0;
        private static final double MODBUS_SCALE_FACTOR_SCREW_PROGRAM_DEV = 100.0;
        private static final double MODBUS_SCALE_FACTOR_SCREW_PROGRAM_ROBOT_START_OFFSET = 100.0;
        private static final double MODBUS_SCALE_FACTOR_SCREW = 100.0;
        private static final double MM_TO_M = 0.001;
        private static final double M_TO_MM = 1000.0;

        private ModbusScaleFactors() {
        }
    }
}

