/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util.swing;

import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingHelper;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class SwingStandards {
    public static JLabel createStandardLabel(String label, boolean isBold, boolean isCentered, SwingAbstractStyle style) {
        JLabel newLabel = new JLabel(label);
        if (isBold) {
            newLabel.setFont(newLabel.getFont().deriveFont((float)style.getDefaultFontSize()).deriveFont(1));
        }
        if (isCentered) {
            newLabel.setHorizontalAlignment(0);
        }
        newLabel.setPreferredSize(style.getLabelSize());
        newLabel.setMaximumSize(newLabel.getPreferredSize());
        return newLabel;
    }

    public static JLabel createLabel(String label, boolean isBold, boolean isCentered, Dimension dimension, int fontSize) {
        JLabel newLabel = new JLabel(label);
        newLabel.setFont(new Font(newLabel.getFont().getFontName(), 0, fontSize));
        if (isBold) {
            newLabel.setFont(newLabel.getFont().deriveFont((float)fontSize).deriveFont(1));
        }
        if (isCentered) {
            newLabel.setHorizontalAlignment(0);
        }
        if (dimension != null) {
            newLabel.setPreferredSize(dimension);
            newLabel.setMaximumSize(newLabel.getPreferredSize());
        }
        return newLabel;
    }

    public static JTextField createStandardTextField(MouseAdapter mouseAdapter, SwingAbstractStyle style) {
        JTextField newTextField = new JTextField();
        newTextField.setPreferredSize(style.getInputFieldSize());
        newTextField.setMaximumSize(newTextField.getPreferredSize());
        if (mouseAdapter != null) {
            newTextField.addMouseListener(mouseAdapter);
        }
        return newTextField;
    }

    public static JTextField createTextField(Dimension dimension, MouseAdapter mouseAdapter) {
        JTextField newTextField = new JTextField();
        newTextField.setPreferredSize(dimension);
        newTextField.setMaximumSize(newTextField.getPreferredSize());
        newTextField.setBorder(SwingHelper.createBlackBorder());
        if (mouseAdapter != null) {
            newTextField.addMouseListener(mouseAdapter);
        }
        return newTextField;
    }

    public static JTextArea createTextArea(String text, Dimension dimension, MouseAdapter mouseAdapter) {
        JTextArea textArea = new JTextArea();
        textArea.setPreferredSize(dimension);
        textArea.setMaximumSize(textArea.getPreferredSize());
        textArea.setText(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setOpaque(false);
        if (mouseAdapter != null) {
            textArea.addMouseListener(mouseAdapter);
        }
        return textArea;
    }

    public static JTextArea createTextArea(String text, Dimension dimension, int fontSize, MouseAdapter mouseAdapter) {
        JTextArea textArea = new JTextArea();
        textArea.setPreferredSize(dimension);
        textArea.setMaximumSize(textArea.getPreferredSize());
        textArea.setText(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setOpaque(false);
        textArea.setFont(new Font(textArea.getFont().getFontName(), 0, fontSize));
        if (mouseAdapter != null) {
            textArea.addMouseListener(mouseAdapter);
        }
        return textArea;
    }

    public static JButton createStandardButton(String label, MouseAdapter mouseAdapter, SwingAbstractStyle style) {
        JButton newButton = new JButton(label);
        newButton.setFocusable(false);
        newButton.setPreferredSize(style.getButtonSizeSmall());
        newButton.setMaximumSize(newButton.getPreferredSize());
        if (mouseAdapter != null) {
            newButton.addMouseListener(mouseAdapter);
        }
        return newButton;
    }

    public static JButton createButton(String label, Dimension dimension, MouseAdapter mouseAdapter) {
        JButton newButton = new JButton(label);
        newButton.setFocusable(false);
        newButton.setPreferredSize(dimension);
        newButton.setMaximumSize(newButton.getPreferredSize());
        if (mouseAdapter != null) {
            newButton.addMouseListener(mouseAdapter);
        }
        return newButton;
    }

    public static JButton createButton(String label, Dimension dimension, Font font, MouseAdapter mouseAdapter) {
        JButton newButton = new JButton(label);
        newButton.setFocusable(false);
        newButton.setPreferredSize(dimension);
        newButton.setMaximumSize(newButton.getPreferredSize());
        newButton.setFont(font);
        if (mouseAdapter != null) {
            newButton.addMouseListener(mouseAdapter);
        }
        return newButton;
    }

    public static JButton createIconButton(Icon icon, Dimension dimension, int borderThickness, MouseAdapter mouseAdapter) {
        JButton newButton = new JButton();
        newButton.setText("");
        if (icon != null) {
            newButton.setIcon(icon);
        }
        newButton.setFocusable(false);
        newButton.setPreferredSize(dimension);
        newButton.setMaximumSize(newButton.getPreferredSize());
        newButton.setBorder(BorderFactory.createLineBorder(SwingAbstractStyle.URColor.UR_BLUE, borderThickness));
        if (mouseAdapter != null) {
            newButton.addMouseListener(mouseAdapter);
        }
        return newButton;
    }

    public static JComboBox createStandardComboBox(String[] values, ActionListener actionListener, SwingAbstractStyle style) {
        JComboBox<String> comboBox = new JComboBox<String>();
        if (values != null) {
            for (String value : values) {
                comboBox.addItem(value);
            }
        }
        comboBox.setFocusable(false);
        comboBox.setPreferredSize(style.getComboBoxSize());
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        if (actionListener != null) {
            comboBox.addActionListener(actionListener);
        }
        return comboBox;
    }

    public static JComboBox createComboBox(String[] values, Dimension dimension, ActionListener actionListener) {
        JComboBox<String> comboBox = new JComboBox<String>();
        if (values != null) {
            for (String value : values) {
                comboBox.addItem(value);
            }
        }
        comboBox.setFocusable(false);
        comboBox.setPreferredSize(dimension);
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        if (actionListener != null) {
            comboBox.addActionListener(actionListener);
        }
        return comboBox;
    }

    public static JCheckBox createStandardCheckBox(String label, int horizontalTextPosition, ActionListener actionListener, SwingAbstractStyle style) {
        JCheckBox newCheckBox = new JCheckBox(label);
        newCheckBox.setHorizontalTextPosition(horizontalTextPosition);
        newCheckBox.setFocusable(false);
        newCheckBox.setPreferredSize(style.getCheckBoxSize());
        newCheckBox.setMaximumSize(newCheckBox.getPreferredSize());
        if (actionListener != null) {
            newCheckBox.addActionListener(actionListener);
        }
        return newCheckBox;
    }

    public static JCheckBox createCheckBox(String label, int horizontalTextPosition, Dimension dimension, boolean checked, ActionListener actionListener) {
        JCheckBox newCheckBox = new JCheckBox(label);
        newCheckBox.setSelected(checked);
        newCheckBox.setHorizontalTextPosition(horizontalTextPosition);
        newCheckBox.setFocusable(false);
        newCheckBox.setPreferredSize(dimension);
        newCheckBox.setMaximumSize(newCheckBox.getPreferredSize());
        if (actionListener != null) {
            newCheckBox.addActionListener(actionListener);
        }
        return newCheckBox;
    }

    public static JSeparator createBlackSeparator(boolean isVertical, int size, int thickness) {
        int direction = 0;
        if (isVertical) {
            direction = 1;
        }
        JSeparator separator = new JSeparator(direction);
        separator.setBorder(SwingHelper.createBlackBorder());
        if (!isVertical) {
            separator.setPreferredSize(new Dimension(size, thickness));
        } else {
            separator.setPreferredSize(new Dimension(thickness, size));
        }
        separator.setMaximumSize(separator.getPreferredSize());
        return separator;
    }

    public static Box createLabelInputField(String label, JTextField inputField, MouseAdapter mouseAdapter, SwingAbstractStyle style) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(label);
        inputField.setFocusable(false);
        inputField.setPreferredSize(style.getInputFieldSize());
        inputField.setMaximumSize(inputField.getPreferredSize());
        inputField.addMouseListener(mouseAdapter);
        horizontalBox.add(jLabel);
        horizontalBox.add(inputField);
        return horizontalBox;
    }

    public static Box createButtonComboBox(String buttonLabel, JButton button, MouseAdapter buttonMouseAdapter, JComboBox comboBox, ItemListener comboBoxItemListener, SwingAbstractStyle style) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        button.setText(buttonLabel);
        button.addMouseListener(buttonMouseAdapter);
        comboBox.setFocusable(false);
        comboBox.setPreferredSize(style.getComboBoxSize());
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        comboBox.addItemListener(comboBoxItemListener);
        horizontalBox.add(button);
        horizontalBox.add(SwingHelper.createHorizontalSpacing(style.getHorizontalSpacing()));
        horizontalBox.add(comboBox);
        return horizontalBox;
    }

    public static JScrollPane createVerticalScrollingTextArea(String text, JTextArea textArea, Dimension dimension, boolean isEditable, boolean setBorder, SwingAbstractStyle style) {
        textArea.setText(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        if (isEditable) {
            textArea.setEditable(false);
        }
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension((int)dimension.getWidth() - style.getVerticalScrollBarWidth(), (int)dimension.getHeight()));
        scrollPane.setMinimumSize(scrollPane.getPreferredSize());
        scrollPane.setMaximumSize(scrollPane.getPreferredSize());
        if (setBorder) {
            scrollPane.setBorder(SwingHelper.createBlackBorder());
        }
        return scrollPane;
    }

    public static JRadioButton createRadioButton(String text, boolean isBold, boolean isCentered, Dimension dimension, int fontSize, boolean isSelected, ActionListener actionListener) {
        JRadioButton rb = new JRadioButton(text);
        if (isBold) {
            rb.setFont(rb.getFont().deriveFont((float)fontSize).deriveFont(1));
        }
        if (isCentered) {
            rb.setHorizontalAlignment(0);
        }
        if (dimension != null) {
            rb.setPreferredSize(dimension);
            rb.setMaximumSize(rb.getPreferredSize());
        }
        if (actionListener != null) {
            rb.addActionListener(actionListener);
        }
        rb.setSelected(isSelected);
        return rb;
    }

    public static JSlider createStdSlider(boolean vertical, int min, int max, int initial_value, ChangeListener changeListener, SwingAbstractStyle style) {
        JSlider slider = new JSlider(vertical ? 1 : 0);
        slider.setMinimum(min);
        slider.setMaximum(max);
        slider.setSize(style.getStandardComponentWidth() * 2 + 2 * style.getHorizontalSpacing(), style.getURComponentHeightTiny());
        slider.setValue(initial_value);
        slider.setMajorTickSpacing(50);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(false);
        slider.setPaintLabels(true);
        Hashtable<Integer, JLabel> position = new Hashtable<Integer, JLabel>();
        position.put(0, new JLabel("0"));
        position.put(25, new JLabel("25"));
        position.put(50, new JLabel("50"));
        position.put(75, new JLabel("75"));
        position.put(100, new JLabel("100"));
        slider.addChangeListener(changeListener);
        return slider;
    }
}

