/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes;

import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.program_nodes.PickBitProgramNodeContribution;
import com.spin.urcap.impl.util.ImageHelper;
import com.spin.urcap.impl.util.PopupTool;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingStandards;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PickBitProgramNodeView
implements SwingProgramNodeView<PickBitProgramNodeContribution> {
    private JComboBox bitHolderComboBox = new JComboBox();
    private final JLabel lblSelectBit = new JLabel();
    private final JLabel lblVelocity = new JLabel();
    private final JLabel lblOffset = new JLabel();
    private final JLabel lblVelocityUnit = new JLabel();
    private final JLabel lblOffsetUnit = new JLabel();
    private final JLabel forceInTCPZLabel = new JLabel();
    private final JLabel forceInTCPZUnitLabel = new JLabel();
    private final JTextField ApproachOffset = new JTextField();
    private final JTextField Velocity = new JTextField();
    private final JTextField forceInTCPZ = new JTextField();
    private final SwingAbstractStyle style;
    private Component velocityInputComponent;
    private Component approachOffsetInputComponent;
    private JButton infoBtn;
    private JPanel safetyPanel;
    private JPanel jPanel;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JPanel infoPanel;
    private final JLabel lblSafetyWarning = new JLabel();
    private JCheckBox ckboxEnableSafety;
    private JCheckBox ckboxAdvancedSettings;
    private boolean enableSafety = true;

    public PickBitProgramNodeView(SwingAbstractStyle style) {
        this.style = style;
    }

    public void buildUI(JPanel jPanel, final ContributionProvider<PickBitProgramNodeContribution> contributionProvider) {
        this.jPanel = jPanel;
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.mainPanel = new JPanel();
        this.bottomPanel = new JPanel(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        Component comboBox = this.createReferencingComboBox(contributionProvider);
        this.lblSelectBit.setFont(this.lblSelectBit.getFont().deriveFont(1));
        this.createSafetyPanel(contributionProvider);
        this.createCheckBoxAdvancedSettings();
        this.createInfoButton();
        this.createInfoPanel();
        this.velocityInputComponent = this.createLabelInputField(this.lblVelocity, this.lblVelocityUnit, this.Velocity, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((PickBitProgramNodeContribution)contributionProvider.get()).getKeyboardVelocity();
                keyboardInput.show(PickBitProgramNodeView.this.Velocity, ((PickBitProgramNodeContribution)contributionProvider.get()).getCallbackVelocity());
            }
        });
        this.approachOffsetInputComponent = this.createLabelInputField(this.lblOffset, this.lblOffsetUnit, this.ApproachOffset, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyboardNumberInput<Double> keyboardInput = ((PickBitProgramNodeContribution)contributionProvider.get()).getKeyboardApproachOffset();
                keyboardInput.show(PickBitProgramNodeView.this.ApproachOffset, ((PickBitProgramNodeContribution)contributionProvider.get()).getCallbackApproachOffset());
            }
        });
        JLabel logoLabel = this.createLogo("/com/spin/urcap/icons/SR_logo200x50.jpg");
        JLabel img1 = ImageHelper.loadImage("/com/spin/urcap/icons/PickBit.jpg");
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        horizontalBox.add(logoLabel);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(this.safetyPanel);
        this.bottomPanel.add((Component)horizontalBox, "South");
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.lblSelectBit, -1, -1, Short.MAX_VALUE).addComponent(comboBox, -1, -1, -1).addGap(8 * this.style.getURComponentHeightDefault()).addComponent(this.velocityInputComponent, -1, -1, Short.MAX_VALUE).addComponent(this.approachOffsetInputComponent, -1, -1, Short.MAX_VALUE).addComponent(this.ckboxAdvancedSettings, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoBtn, -2, -2, -2).addComponent(img1, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lblSelectBit, -1, -1, Short.MAX_VALUE).addComponent(comboBox, -1, -1, -1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGap(8 * this.style.getURComponentHeightDefault()).addComponent(this.velocityInputComponent, -1, -1, Short.MAX_VALUE).addComponent(this.approachOffsetInputComponent, -1, -1, Short.MAX_VALUE).addComponent(this.ckboxAdvancedSettings, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.infoBtn, -2, -2, -2).addComponent(img1, -1, -1, Short.MAX_VALUE)));
        jPanel.add(this.mainPanel);
        jPanel.add(this.bottomPanel);
    }

    private Component createReferencingComboBox(final ContributionProvider<PickBitProgramNodeContribution> provider) {
        String[] refString = new String[]{this.getTextResource().changeBitSelectBit(), "1", "2", "3"};
        this.bitHolderComboBox = new JComboBox<String>(refString);
        this.bitHolderComboBox.setFocusable(false);
        this.bitHolderComboBox.setPreferredSize(new Dimension(250, 35));
        this.bitHolderComboBox.setMaximumSize(this.bitHolderComboBox.getPreferredSize());
        this.bitHolderComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PickBitProgramNodeView.this.bitHolderComboBox.getSelectedItem() != null && !PickBitProgramNodeView.this.bitHolderComboBox.getSelectedItem().toString().equals(PickBitProgramNodeView.this.getTextResource().changeBitSelectBit())) {
                    ((PickBitProgramNodeContribution)provider.get()).setLastSelectedBit(PickBitProgramNodeView.this.bitHolderComboBox.getSelectedItem().toString());
                }
            }
        });
        return this.bitHolderComboBox;
    }

    public void updateBitHolderComboBox(String defaultBit) {
        if (defaultBit != null) {
            this.bitHolderComboBox.setSelectedItem(defaultBit);
        }
    }

    private Box createLabelInputField(JLabel label, JLabel unit, JTextField inputField, MouseAdapter mouseAdapter) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        label.setHorizontalAlignment(2);
        unit.setHorizontalAlignment(4);
        inputField.setFocusable(false);
        inputField.setPreferredSize(new Dimension(100, 30));
        inputField.setMaximumSize(inputField.getPreferredSize());
        inputField.addMouseListener(mouseAdapter);
        horizontalBox.add(label);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(inputField);
        horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
        horizontalBox.add(unit);
        return horizontalBox;
    }

    private void createCheckBoxAdvancedSettings() {
        this.ckboxAdvancedSettings = SwingStandards.createCheckBox(this.getTextResource().placeBitAdvancedSettings(), 10, this.style.getCheckBoxSize(), false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickBitProgramNodeView.this.setComponentsVisible(PickBitProgramNodeView.this.ckboxAdvancedSettings.isSelected());
            }
        });
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    private void createSafetyPanel(final ContributionProvider<PickBitProgramNodeContribution> contributionProvider) {
        this.safetyPanel = new JPanel();
        this.safetyPanel.setBorder(this.style.getDefaultBtnBoarder());
        GroupLayout layout = new GroupLayout(this.safetyPanel);
        this.safetyPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.lblSafetyWarning.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/placeholder_large.png"))));
        this.lblSafetyWarning.setHorizontalAlignment(0);
        this.lblSafetyWarning.setVerticalAlignment(0);
        Box forceInTCPZComponent = this.createLabelInputField(this.forceInTCPZLabel, this.forceInTCPZUnitLabel, this.forceInTCPZ, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((PickBitProgramNodeContribution)contributionProvider.get()).getKeyboardForForceInTCPZ().show(PickBitProgramNodeView.this.forceInTCPZ, ((PickBitProgramNodeContribution)contributionProvider.get()).getCallbackForForceInTCPZ());
            }
        });
        this.ckboxEnableSafety = SwingStandards.createCheckBox(this.getTextResource().softSafetyEnable(), 10, this.style.getCheckBoxSize(), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PickBitProgramNodeView.this.ckboxEnableSafety.isSelected()) {
                    PickBitProgramNodeView.this.enableSafety = true;
                    PickBitProgramNodeView.this.lblSafetyWarning.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/placeholder_large.png"))));
                    PickBitProgramNodeView.this.forceInTCPZ.setEnabled(true);
                    PickBitProgramNodeView.this.forceInTCPZ.setEditable(true);
                    PickBitProgramNodeView.this.forceInTCPZLabel.setEnabled(true);
                    PickBitProgramNodeView.this.forceInTCPZUnitLabel.setEnabled(true);
                    PickBitProgramNodeView.this.ckboxEnableSafety.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
                    PickBitProgramNodeView.this.safetyPanel.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
                } else if (PopupTool.showDialogOptionWarning(PickBitProgramNodeView.this.getTextResource().softSafetyPopupText(), PickBitProgramNodeView.this.getTextResource().softSafetyPopupTitle(), PickBitProgramNodeView.this.getTextResource().optionYes(), PickBitProgramNodeView.this.getTextResource().optionNo(), new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png")))) > 0) {
                    PickBitProgramNodeView.this.ckboxEnableSafety.setSelected(true);
                } else {
                    PickBitProgramNodeView.this.enableSafety = false;
                    PickBitProgramNodeView.this.lblSafetyWarning.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_large.png"))));
                    PickBitProgramNodeView.this.forceInTCPZ.setEnabled(false);
                    PickBitProgramNodeView.this.forceInTCPZ.setEditable(false);
                    PickBitProgramNodeView.this.forceInTCPZLabel.setEnabled(false);
                    PickBitProgramNodeView.this.forceInTCPZUnitLabel.setEnabled(false);
                    PickBitProgramNodeView.this.ckboxEnableSafety.setBackground(SwingAbstractStyle.URColor.UR_YELLOW);
                    PickBitProgramNodeView.this.safetyPanel.setBackground(SwingAbstractStyle.URColor.UR_YELLOW);
                }
                ((PickBitProgramNodeContribution)contributionProvider.get()).safetySettingsChanged(PickBitProgramNodeView.this.ckboxEnableSafety.isSelected());
            }
        });
        this.ckboxEnableSafety.setSelected(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ckboxEnableSafety, -2, -2, Short.MAX_VALUE).addComponent(forceInTCPZComponent, -2, -2, Short.MAX_VALUE)).addComponent(this.lblSafetyWarning, -2, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.ckboxEnableSafety, -2, -2, Short.MAX_VALUE).addComponent(forceInTCPZComponent, -2, -2, Short.MAX_VALUE)).addComponent(this.lblSafetyWarning, -2, -2, Short.MAX_VALUE)));
    }

    private void createInfoButton() {
        this.infoBtn = new JButton();
        BufferedImage img = null;
        try {
            img = ImageHelper.read("/com/spin/urcap/icons/UR_e-Series_1.0/information_icon.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (img == null) {
            return;
        }
        this.infoBtn.setIcon(new ImageIcon(img));
        this.infoBtn.setPreferredSize(new Dimension(35, 35));
        this.infoBtn.setMaximumSize(this.infoBtn.getPreferredSize());
        this.infoBtn.setBorderPainted(false);
        this.infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickBitProgramNodeView.this.mainPanel.setVisible(false);
                PickBitProgramNodeView.this.bottomPanel.setVisible(false);
                PickBitProgramNodeView.this.jPanel.remove(PickBitProgramNodeView.this.mainPanel);
                PickBitProgramNodeView.this.jPanel.remove(PickBitProgramNodeView.this.bottomPanel);
                PickBitProgramNodeView.this.jPanel.add(PickBitProgramNodeView.this.infoPanel);
                PickBitProgramNodeView.this.infoPanel.setVisible(true);
            }
        });
    }

    private void createInfoPanel() {
        this.infoPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(layout);
        JLabel lblInfoTitle = SwingStandards.createLabel(this.getTextResource().pickBitInfoTitle(), true, false, new Dimension(450, 50), this.style.getURFontSizeMainHeading());
        JTextArea lblInfoDescription = this.createInfoText(this.getTextResource().pickBitInfoDescription());
        JButton returnBtn = new JButton(this.getTextResource().optionReturn());
        returnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickBitProgramNodeView.this.setPanelsVisible();
            }
        });
        JLabel logo = this.createLogo("/com/spin/urcap/icons/SR_logo200x50.jpg");
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(lblInfoTitle, -2, -2, -2).addComponent(lblInfoDescription, -2, -2, -2).addComponent(returnBtn, -2, -2, -2).addComponent(logo, -2, -2, -2)).addGroup(layout.createParallelGroup().addGap(this.style.getHorizontalLargeSpacing() * 8)).addGroup(layout.createParallelGroup()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lblInfoTitle, -2, -2, -2).addComponent(lblInfoDescription, -2, -2, -2).addComponent(returnBtn, -2, -2, -2).addGap(this.style.getVerticalLargeSpacing() * 10 + this.style.getVerticalSmallSpacing()).addComponent(logo, -2, -2, -2)).addGroup(layout.createSequentialGroup()).addGroup(layout.createSequentialGroup()));
    }

    public void setPanelsVisible() {
        this.jPanel.remove(this.infoPanel);
        this.jPanel.add(this.mainPanel);
        this.jPanel.add(this.bottomPanel);
        this.mainPanel.setVisible(true);
        this.bottomPanel.setVisible(true);
        this.infoPanel.setVisible(false);
        this.ckboxAdvancedSettings.setSelected(false);
    }

    private JTextArea createInfoText(String text) {
        JTextArea info = new JTextArea();
        info.setText(text);
        info.setLineWrap(true);
        info.setPreferredSize(new Dimension(350, 80));
        info.setMaximumSize(info.getPreferredSize());
        info.setEditable(false);
        info.setWrapStyleWord(true);
        info.setFont(new Font(info.getFont().getFontName(), this.style.getUrFontStylePlain(), this.style.getUrFontSizeDefault()));
        return info;
    }

    public void setForceInTCPZLabel(String data) {
        this.forceInTCPZLabel.setText(data);
    }

    public void setForceInTCPZUnitLabel(String data) {
        this.forceInTCPZUnitLabel.setText(data);
    }

    public String getForceInTCPZ() {
        return this.forceInTCPZ.getText();
    }

    public void setForceInTCPZ(String data) {
        this.forceInTCPZ.setText(data);
    }

    public boolean getEnableSafety() {
        return this.enableSafety;
    }

    public void setApproachOffset(Double value) {
        this.ApproachOffset.setText(value.toString());
    }

    public void setVelocity(Double value) {
        this.Velocity.setText(value.toString());
    }

    public void setVelocityLabel(String str) {
        this.lblVelocity.setText(str);
    }

    public void setVelocityUnitLabel(String str) {
        this.lblVelocityUnit.setText(str);
    }

    public void setSelectBitLabel(String str) {
        this.lblSelectBit.setText(str);
    }

    public void setL1OffsetLabel(String str) {
        this.lblOffset.setText(str);
    }

    public void setL1OffsetUnitLabel(String str) {
        this.lblOffsetUnit.setText(str);
    }

    public void setComponentsVisible(boolean state) {
        this.velocityInputComponent.setVisible(state);
        this.approachOffsetInputComponent.setVisible(state);
    }

    private JLabel createLogo(String path) {
        JLabel drawing = new JLabel();
        drawing.setHorizontalAlignment(4);
        drawing.setVerticalAlignment(1);
        drawing.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource(path))));
        drawing.setSize(this.style.getDefaultLogoSize());
        return drawing;
    }
}

