/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.bit_change;

import com.spin.urcap.impl.installation_node.bit_change.BitChangeTabContribution;
import com.spin.urcap.impl.util.ImageHelper;
import com.spin.urcap.impl.util.PopupTool;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingStandards;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.domain.UserInterfaceAPI;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementErrorEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BitChangeTabView {
    private final UserInterfaceAPI uiAPI;
    private final SwingAbstractStyle style;
    private final JPanel mountingPanel = new JPanel();
    private JLabel lblBitChangeImg;
    private final JLabel savedLabelA = new JLabel();
    private final JLabel savedLabelB = new JLabel();
    private final JLabel savedLabelC = new JLabel();
    private final JLabel savedLabelMove = new JLabel();
    private ImageIcon iconA;
    private ImageIcon iconB;
    private ImageIcon iconC;
    private JButton TeachPointAButton;
    private JButton TeachPointBButton;
    private JButton TeachPointCButton;
    private JButton MoveToFeatureButton;

    public BitChangeTabView(SwingAbstractStyle style, ViewAPIProvider apiProvider) {
        this.uiAPI = apiProvider.getUserInterfaceAPI();
        this.style = style;
        try {
            ImageIcon imgTCPCustom = new ImageIcon(ImageHelper.read("/com/spin/urcap/icons/customTCP21.png"));
            ImageIcon imgTCPStandard = new ImageIcon(ImageHelper.read("/com/spin/urcap/icons/toolStandardTCP.png"));
            imgTCPCustom = ImageHelper.scaleImage(imgTCPCustom, 400, 300);
            imgTCPStandard = ImageHelper.scaleImage(imgTCPStandard, 400, 300);
            this.iconA = new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/bitChangerA.JPG")));
            this.iconB = new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/bitChangerB.JPG")));
            this.iconC = new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/bitChangerC.JPG")));
            this.iconA = ImageHelper.scaleImage(this.iconA, 350, 250);
            this.iconB = ImageHelper.scaleImage(this.iconB, 350, 250);
            this.iconC = ImageHelper.scaleImage(this.iconC, 350, 250);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getIndex() {
        return 1;
    }

    public JPanel buildUI(JPanel parentPanel, BitChangeTabContribution contribution) {
        GroupLayout layout = new GroupLayout(this.mountingPanel);
        this.mountingPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        this.createLabel(contribution, true, this.style.getURFontSizeMainHeading());
        JLabel lblLogo = this.createLogo("/com/spin/urcap/icons/SR_LOGO_BORDER.png");
        this.lblBitChangeImg = ImageHelper.loadImage("/com/spin/urcap/icons/bitChangerA.JPG", 350, 250);
        JTextArea txtTCP = this.createInfoText(contribution);
        txtTCP.setPreferredSize(new Dimension(350, 100));
        txtTCP.setMaximumSize(txtTCP.getPreferredSize());
        this.createHorozontalLine(parentPanel);
        JLabel lblCalibHeadline = SwingStandards.createLabel(contribution.getTeachTitleText(), true, false, new Dimension(400, 50), this.style.getURFontSizeMainHeading());
        this.TeachPointAButton = this.createPointAButton(contribution);
        this.TeachPointBButton = this.createPointBButton(contribution);
        this.TeachPointCButton = this.createCreatePointCButton(contribution);
        this.MoveToFeatureButton = this.createMoveHereButton(contribution);
        this.savedLabelA.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/approve.png"))));
        this.savedLabelB.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/approve.png"))));
        this.savedLabelC.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/approve.png"))));
        this.savedLabelMove.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/approve.png"))));
        this.savedLabelA.setVisible(false);
        this.savedLabelB.setVisible(false);
        this.savedLabelC.setVisible(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(lblCalibHeadline, -2, -2, -2).addComponent(txtTCP, -2, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.TeachPointAButton, -2, -2, -2).addComponent(this.savedLabelA, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.TeachPointBButton, -2, -2, -2).addComponent(this.savedLabelB, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.TeachPointCButton, -2, -2, -2).addComponent(this.savedLabelC, -2, -2, -2)).addComponent(this.MoveToFeatureButton, -2, -2, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblBitChangeImg, -1, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblLogo, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(lblCalibHeadline, -2, -2, -2).addComponent(txtTCP, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.TeachPointAButton, -2, -2, -2).addComponent(this.savedLabelA, -2, -2, -2)).addGap(this.style.getVerticalSpacing()).addGroup(layout.createParallelGroup().addComponent(this.TeachPointBButton, -2, -2, -2).addComponent(this.savedLabelB, -2, -2, -2)).addGap(this.style.getVerticalSpacing()).addGroup(layout.createParallelGroup().addComponent(this.TeachPointCButton, -2, -2, -2).addComponent(this.savedLabelC, -2, -2, -2)).addGap(this.style.getVerticalSpacing()).addComponent(this.MoveToFeatureButton, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblBitChangeImg, -1, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(lblLogo, -1, -1, Short.MAX_VALUE)));
        return this.mountingPanel;
    }

    JPanel createHorozontalLine(final JPanel parentPanel) {
        return new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                g.drawLine(0, 0, parentPanel.getWidth(), 0);
                BitChangeTabView.this.style.getURColor();
                g.setColor(SwingAbstractStyle.URColor.UR_BLACK);
            }
        };
    }

    private JLabel createLabel(BitChangeTabContribution contribution, boolean isBold, int fontSize) {
        JLabel label = new JLabel();
        label.setText(contribution.getTitleText());
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(10);
        label.setPreferredSize(new Dimension(this.style.getStandardComponentWidth(), this.style.getURComponentHeightDefault()));
        label.setFont(new Font(label.getFont().getFontName(), isBold ? this.style.getUrFontStyleBold() : this.style.getUrFontStylePlain(), fontSize));
        return label;
    }

    private JLabel createLogo(String path) {
        JLabel drawing = new JLabel();
        drawing.setHorizontalAlignment(4);
        drawing.setVerticalAlignment(1);
        drawing.setIcon(new ImageIcon(this.getClass().getResource(path)));
        drawing.setSize(this.style.getDefaultLogoSize());
        return drawing;
    }

    private JButton createPointAButton(final BitChangeTabContribution contribution) {
        JButton btn = new JButton(contribution.getTeachAText());
        btn.setFocusPainted(false);
        btn.setPreferredSize(new Dimension(250, 60));
        btn.setMaximumSize(this.style.getButtonSizeDefault());
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (contribution.featureIsSet()) {
                    if (PopupTool.showDialogOptionWarning("Do you want to teach a new bit changer station?", "Warning - Bit changer station already taught", "No", "Yes", new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png")))) > 0) {
                        contribution.removePoints();
                        contribution.removeFeature();
                        contribution.setPointA();
                    }
                } else {
                    contribution.setPointA();
                }
            }
        });
        return btn;
    }

    private JButton createPointBButton(final BitChangeTabContribution contribution) {
        JButton btn = new JButton(contribution.getTeachBText());
        btn.setFocusPainted(false);
        btn.setPreferredSize(new Dimension(250, 60));
        btn.setMaximumSize(this.style.getButtonSizeDefault());
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                contribution.setPointB();
            }
        });
        return btn;
    }

    private JButton createCreatePointCButton(final BitChangeTabContribution contribution) {
        JButton btn = new JButton(contribution.getTeachCText());
        btn.setFocusPainted(false);
        btn.setPreferredSize(new Dimension(250, 60));
        btn.setMaximumSize(this.style.getButtonSizeDefault());
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                contribution.setPointC();
            }
        });
        return btn;
    }

    private JButton createMoveHereButton(final BitChangeTabContribution contribution) {
        JButton btn = new JButton(contribution.getMoveToFeatureText());
        btn.setFocusPainted(false);
        btn.setPreferredSize(new Dimension(250, 60));
        btn.setMaximumSize(this.style.getButtonSizeDefault());
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BitChangeTabView.this.moveRobotSafe(contribution.getSpinBitChangeFeature());
            }
        });
        return btn;
    }

    private JTextArea createInfoText(BitChangeTabContribution contribution) {
        JTextArea info = new JTextArea();
        info.setText(contribution.getInfoText());
        info.setLineWrap(true);
        info.setPreferredSize(new Dimension(350, 200));
        info.setMaximumSize(info.getPreferredSize());
        info.setEditable(false);
        info.setWrapStyleWord(true);
        info.setFont(new Font(info.getFont().getFontName(), this.style.getUrFontStylePlain(), this.style.getUrFontSizeDefault()));
        return info;
    }

    public void moveRobotSafe(Pose pose) {
        if (pose != null) {
            this.uiAPI.getUserInteraction().getRobotMovement().requestUserToMoveRobot(pose, new RobotMovementCallback(){

                public void onComplete(MovementCompleteEvent event) {
                }

                public void onError(MovementErrorEvent event) {
                }
            });
        }
    }

    public void setMoveBtnEnabled(Boolean state) {
        this.MoveToFeatureButton.setEnabled(state);
    }

    public void setTeachPointBButtonEnabled(Boolean state) {
        this.TeachPointBButton.setEnabled(state);
    }

    public void setTeachPointCButtonEnabled(Boolean state) {
        this.TeachPointCButton.setEnabled(state);
    }

    public void setApproveLabelAVisible(boolean state) {
        this.savedLabelA.setVisible(state);
    }

    public void setApproveLabelBVisible(boolean state) {
        this.savedLabelB.setVisible(state);
    }

    public void setApproveLabelCVisible(boolean state) {
        this.savedLabelC.setVisible(state);
    }

    public void setTeachIcon(String ABC) {
        switch (ABC) {
            case "A": {
                this.lblBitChangeImg.setIcon(this.iconA);
                break;
            }
            case "B": {
                this.lblBitChangeImg.setIcon(this.iconB);
                break;
            }
            case "C": {
                this.lblBitChangeImg.setIcon(this.iconC);
            }
        }
    }
}

