/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node;

import com.spin.urcap.impl.installation_node.InstallationContribution;
import com.spin.urcap.impl.installation_node.bit_change.BitChangeTabView;
import com.spin.urcap.impl.installation_node.feeder.FeederView;
import com.spin.urcap.impl.installation_node.settings.SettingsTabView;
import com.spin.urcap.impl.util.SWVersion;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;

public class InstallationView
implements SwingInstallationNodeView<InstallationContribution> {
    private JTabbedPane configurationTabs;
    private final BitChangeTabView bitChangeTabView;
    private final SettingsTabView settingsTabView;
    private final FeederView feederView;
    private final ViewAPIProvider apiProvider;
    private final SWVersion swVersion;

    public InstallationView(ViewAPIProvider apiProvider, SwingAbstractStyle style) {
        this.bitChangeTabView = new BitChangeTabView(style, apiProvider);
        this.settingsTabView = new SettingsTabView(style);
        this.feederView = new FeederView();
        this.apiProvider = apiProvider;
        this.swVersion = new SWVersion(this.apiProvider);
    }

    public final BitChangeTabView getBitChangeTabView() {
        return this.bitChangeTabView;
    }

    public final SettingsTabView getSettingsTabView() {
        return this.settingsTabView;
    }

    public final FeederView getDispenserTabView() {
        return this.feederView;
    }

    public void buildUI(JPanel jPanel, InstallationContribution contribution) {
        jPanel.setLayout((LayoutManager)new MigLayout("", "", ""));
        try {
            if (this.swVersion.check()) {
                jPanel.add(this.createPanes(jPanel, contribution));
            } else {
                jPanel.add(this.createDefaultInfo(this.swVersion));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JTabbedPane createPanes(JPanel panel, final InstallationContribution contribution) {
        this.configurationTabs = new JTabbedPane();
        this.configurationTabs.addTab(contribution.getSettingsTabContribution().NodeTitle(), this.settingsTabView.buildUI(panel, contribution.getSettingsTabContribution()));
        this.configurationTabs.addTab(contribution.getMountingTabContribution().NodeTitle(), this.bitChangeTabView.buildUI(panel, contribution.getMountingTabContribution()));
        this.configurationTabs.addTab(contribution.getFeederTabContribution().getTitleText(), this.feederView.buildUI(contribution.getFeederTabContribution()));
        this.configurationTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                contribution.openTab();
            }
        });
        return this.configurationTabs;
    }

    public int getOpenedTabIndex() {
        return this.configurationTabs.getSelectedIndex();
    }

    private Box createDefaultInfo(SWVersion swVersion) {
        Box infoBox = Box.createVerticalBox();
        infoBox.setAlignmentX(0.0f);
        JTextPane pane = new JTextPane();
        pane.setBorder(BorderFactory.createEmptyBorder());
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(attributeSet, 0.5f);
        StyleConstants.setLeftIndent(attributeSet, 0.0f);
        pane.setParagraphAttributes(attributeSet, false);
        pane.setBounds(10, 10, 200, 400);
        pane.setText(swVersion.getVersionInfoText());
        pane.setEditable(false);
        pane.setMaximumSize(pane.getPreferredSize());
        pane.setBackground(infoBox.getBackground());
        infoBox.add(pane);
        return infoBox;
    }
}

