/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component;

import com.spin.util.logging.SpinLog;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBox<ItemType>
extends JComboBox<ItemType> {
    public ComboBox(ComboBoxModel<ItemType> aModel) {
        super(aModel);
        this.configureStyle();
    }

    public ComboBox(ItemType[] items) {
        super(items);
        this.configureStyle();
    }

    public ComboBox(Vector<ItemType> items) {
        super(items);
        this.configureStyle();
    }

    public ComboBox() {
        this.configureStyle();
    }

    @NotNull
    public ArrayList<ItemType> getAllItems() {
        ArrayList items = new ArrayList();
        for (int i = 0; i < this.getItemCount(); ++i) {
            items.add(this.getItemAt(i));
        }
        return items;
    }

    @NotNull
    private static <ItemType> ListCellRenderer<? super ItemType> addDefaultTextRendering(@NotNull ListCellRenderer<? super ItemType> renderer, @Nullable String defaultText) {
        return (list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            if (value == null) {
                label.setText(String.format("-%s-", defaultText));
            }
            return label;
        };
    }

    @NotNull
    private static <ItemType> ListCellRenderer<? super ItemType> addLeftMargin(@NotNull ListCellRenderer<? super ItemType> renderer) {
        return (list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            Border border = label.getBorder();
            Border margin = BorderFactory.createEmptyBorder(0, 5, 0, 0);
            label.setBorder(BorderFactory.createCompoundBorder(border, margin));
            return label;
        };
    }

    @Override
    public void setRenderer(ListCellRenderer<? super ItemType> renderer) {
        super.setRenderer(ComboBox.addLeftMargin(renderer));
    }

    public void setDefaultText(@Nullable String defaultText) {
        super.setRenderer(ComboBox.addDefaultTextRendering(this.getRenderer(), defaultText));
    }

    public void runWithoutFiringActionsEvents(@NotNull Runnable runnable) {
        List<ActionListener> listeners = Arrays.asList(this.getActionListeners());
        SpinLog.print("action listener count=" + listeners.size());
        listeners.forEach(this::removeActionListener);
        runnable.run();
        listeners.forEach(this::addActionListener);
    }

    private void configureStyle() {
        this.setURHeight();
    }

    private void setURHeight() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension maximumSize = super.getMaximumSize();
        preferredSize.height = 40;
        maximumSize.height = Integer.MAX_VALUE;
        maximumSize.width = Integer.MAX_VALUE;
        super.setPreferredSize(preferredSize);
        super.setMaximumSize(maximumSize);
    }
}

