/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.bridge_communication.program_data.ProgramDataConsumer;
import com.spin.bridge_communication.program_data.ProgramDataProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.domain.Group;
import com.spin.domain.Program;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrewdrivingSetupData {
    @NotNull
    private final DataModel model;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final SimpleValueFactory simpleValueFactory;
    @NotNull
    private final ProgramDataProvider programDataProvider;
    @NotNull
    private Runnable availableProgramsAndGroupsCallback = () -> {};
    @NotNull
    private final ProgramDataConsumer programDataConsumer = (programs, groups) -> this.availableProgramsAndGroupsCallback.run();

    ScrewdrivingSetupData(@NotNull DataModel model, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.model = model;
        ProgramAPI programAPI = apiProvider.getProgramAPIProvider().getProgramAPI();
        this.undoRedoManager = programAPI.getUndoRedoManager();
        this.simpleValueFactory = programAPI.getValueFactoryProvider().getSimpleValueFactory();
        this.programDataProvider = ((InstallationContribution)programAPI.getInstallationNode(InstallationContribution.class)).getProgramDataProvider();
    }

    void setOnProgramDataChangedCallback(@NotNull Runnable callback) {
        this.availableProgramsAndGroupsCallback = callback;
        this.programDataProvider.registerConsumer(this.programDataConsumer);
    }

    void clearOnProgramsDataChangedCallback() {
        this.availableProgramsAndGroupsCallback = () -> {};
        this.programDataProvider.unregisterConsumer(this.programDataConsumer);
    }

    void saveSpinTargetVariable(Variable variable) {
        this.model.set("spin_target", variable);
    }

    @NotNull
    Set<Group> availableGroups() {
        return this.programDataProvider.getGroups();
    }

    @NotNull
    Set<Program> availablePrograms() {
        Group selectedGroup = this.selectedGroup();
        return selectedGroup == null ? this.getPrograms() : this.getPrograms(selectedGroup.programs());
    }

    @NotNull
    Set<Program> getPrograms() {
        return this.programDataProvider.getPrograms();
    }

    @NotNull
    Set<Program> getPrograms(Set<UUID> programUuids) {
        Set<Program> programs = this.programDataProvider.getPrograms();
        return programs.stream().filter(program -> programUuids.contains(program.uuid())).collect(Collectors.toSet());
    }

    @Nullable
    Group selectedGroup() {
        UUID selectedGroupUUID = this.loadSelectedGroupUUID();
        return selectedGroupUUID == null ? null : (Group)this.availableGroups().stream().filter(group -> group.uuid().equals(selectedGroupUUID)).findFirst().orElse(null);
    }

    void setSelectedGroup(@Nullable Group group) {
        if (group == null) {
            this.undoRedoManager.recordChanges(() -> this.model.remove("group"));
        } else {
            this.undoRedoManager.recordChanges(() -> this.model.set("group", group.uuid().toString()));
        }
    }

    @Nullable
    private UUID loadSelectedGroupUUID() {
        String uuidString = this.model.get("group", (String)null);
        return uuidString == null ? null : UUID.fromString(uuidString);
    }

    @Nullable
    Program selectedProgram() {
        UUID selectedProgramUUID = this.loadSelectedProgramUUID();
        return selectedProgramUUID == null ? null : (Program)this.availablePrograms().stream().filter(program -> program.uuid().equals(selectedProgramUUID)).findFirst().orElse(null);
    }

    void setSelectedProgram(@NotNull Program program) {
        this.undoRedoManager.recordChanges(() -> this.model.set("program", program.uuid().toString()));
    }

    void clearSelectedProgram() {
        this.undoRedoManager.recordChanges(() -> this.model.remove("program"));
    }

    @Nullable
    private UUID loadSelectedProgramUUID() {
        String programId = this.model.get("program", (String)null);
        return programId == null ? null : UUID.fromString(programId);
    }

    @Nullable
    public Pose screwPose() {
        return this.model.get("pose", (Pose)null);
    }

    void setScrewPose(@NotNull Pose pose) {
        this.undoRedoManager.recordChanges(() -> this.model.set("pose", pose));
    }

    void removeScrewPose() {
        this.undoRedoManager.recordChanges(() -> this.model.remove("pose"));
    }

    public boolean useSpinTarget() {
        return this.model.get("useSpinTarget", false);
    }

    void setUseSpinTarget(boolean selected) {
        this.model.set("useSpinTarget", selected);
    }

    @NotNull
    Force robotForce() {
        return this.model.get("robotForce", this.simpleValueFactory.createForce(20.0, Force.Unit.N));
    }

    void setRobotForce(@NotNull Force force) {
        this.undoRedoManager.recordChanges(() -> this.model.set("robotForce", force));
    }

    @NotNull
    Length s1Distance() {
        return this.model.get("s1Distance", this.simpleValueFactory.createLength(6.0, Length.Unit.MM));
    }

    void setS1Distance(@NotNull Length distance) {
        this.undoRedoManager.recordChanges(() -> this.model.set("s1Distance", distance));
    }

    boolean isValid() {
        return this.selectedProgram() != null && (this.screwPose() != null || this.useSpinTarget());
    }

    @NotNull
    Length minAllowedS1Distance() {
        return this.simpleValueFactory.createLength(0.0, Length.Unit.MM);
    }

    @NotNull
    Length maxAllowedS1Distance() {
        return this.simpleValueFactory.createLength(40.0, Length.Unit.MM);
    }
}

