/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_OK;

import com.spin.core.program_node.screwdriving_setup.on_OK.OnOkText;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.api.NodeFactory;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import org.jetbrains.annotations.NotNull;

public class OnOkContribution
implements ProgramNodeContribution {
    @NotNull
    private final String nodeTitle;

    OnOkContribution(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType nodeCreationType) {
        this.nodeTitle = apiProvider.getTextResource().load(OnOkText.ON_OK);
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            OnOkContribution.buildSubTree(apiProvider, this);
        }
    }

    private static void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull OnOkContribution contribution) {
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        try {
            NodeFactory.addMoveAwayFolder(rootNode, apiProvider.getProgramAPIProvider().getProgramAPI());
        }
        catch (TreeStructureException e) {
            SpinLog.print("Cannot add child nodes to onSuccess node: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        writer.appendLine("if (" + MultiInstall.urscriptPrefix() + "result_evaluation == 2):");
        writer.appendLine("  sync()");
        writer.writeChildren();
    }
}

