/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw;

import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.load_screw.LoadScrewData;
import com.spin.core.program_node.load_screw.LoadScrewScriptGenerator;
import com.spin.core.program_node.load_screw.LoadScrewText;
import com.spin.core.program_node.load_screw.LoadScrewView;
import com.spin.core.program_node.load_screw.pick_screw.PickScrewService;
import com.spin.core.program_node.safe_approach.SafeApproachInterface;
import com.spin.core.program_node.safe_approach.SafeApproachService;
import com.spin.domain.MultiInstall;
import com.spin.domain.ScrewFeeder;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.api.NodeFactory;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.DirectionNode;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.UntilNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.variable.Variable;
import org.jetbrains.annotations.NotNull;

public class LoadScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final LoadScrewView loadScrewView;
    @NotNull
    private final LoadScrewData data;
    @NotNull
    private final ExtendedProgramAPIProvider apiProvider;
    @NotNull
    private final LoadScrewScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final InstallationContribution installationContribution;

    LoadScrewContribution(@NotNull LoadScrewView loadScrewView, @NotNull LoadScrewData data, @NotNull LoadScrewScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType creationType) throws TreeStructureException {
        this.loadScrewView = loadScrewView;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.apiProvider = apiProvider;
        this.textResource = apiProvider.getTextResource();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
        if (creationType == CreationContext.NodeCreationType.NEW) {
            this.buildSubTree();
        }
    }

    private void buildSubTree() throws TreeStructureException {
        TreeNode rootNode = this.apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        ProgramNodeFactory factory = this.apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        TreeNode folderTreeNode = NodeFactory.addFolderNode(rootNode, factory, "load screw");
        ExpressionBuilder expressionBuilder = this.apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        AssignmentNode aboveFeeder = NodeFactory.createAssignmentNode(factory, this.data.aboveFeederVar(), LoadScrewContribution.createExpression(expressionBuilder));
        folderTreeNode.addChild((ProgramNode)aboveFeeder);
        MoveNode moveJNode = NodeFactory.createMoveJNode(factory);
        TreeNode moveJTreeNode = folderTreeNode.addChild((ProgramNode)moveJNode);
        WaypointNode waypointNode = NodeFactory.createWaypointNode(this.data.aboveFeederVar(), this.apiProvider.getProgramAPIProvider().getProgramAPI());
        moveJTreeNode.addChild((ProgramNode)waypointNode);
        URCapProgramNode safeApproachNode = factory.createURCapProgramNode(SafeApproachService.class);
        TreeNode safeApproachTree = folderTreeNode.addChild((ProgramNode)safeApproachNode);
        SafeApproachInterface tmp = (SafeApproachInterface)safeApproachNode.getAs(SafeApproachInterface.class);
        Variable safeApproachTarget = tmp.getSafeApproachTarget();
        expressionBuilder = this.apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        AssignmentNode assignmentNode = NodeFactory.createAssignmentNode(factory, safeApproachTarget, LoadScrewContribution.createSafeExpression(expressionBuilder));
        folderTreeNode.insertChildBefore(safeApproachTree, (ProgramNode)assignmentNode);
        expressionBuilder = this.apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        Variable safeApproachCoverDist = tmp.getSafeApproachCoverDist();
        AssignmentNode coverDistNode = NodeFactory.createAssignmentNode(factory, safeApproachCoverDist, LoadScrewContribution.create0expression(expressionBuilder));
        folderTreeNode.insertChildBefore(safeApproachTree, (ProgramNode)coverDistNode);
        URCapProgramNode pickScrew = factory.createURCapProgramNode(PickScrewService.class);
        folderTreeNode.addChild((ProgramNode)pickScrew);
        MoveNode moveLNode = NodeFactory.createMoveLNode(factory);
        TreeNode moveLTreeNode = folderTreeNode.addChild((ProgramNode)moveLNode);
        DirectionNode directionNode = NodeFactory.createDirectionNode(this.apiProvider.getProgramAPIProvider().getProgramAPI());
        TreeNode directionTreeNode = moveLTreeNode.addChild((ProgramNode)directionNode);
        TreeNode untilDistanceTreeNode = (TreeNode)directionTreeNode.getChildren().get(0);
        UntilNode untilNode = (UntilNode)untilDistanceTreeNode.getProgramNode();
        NodeFactory.configureUntilNode(untilNode, this.apiProvider.getProgramAPIProvider().getProgramAPI());
    }

    public void openView() {
        this.loadScrewView.setScrewFeeders(this.installationContribution.getScrewFeeders());
        this.loadScrewView.selectedScrewFeeder(this.data.selectedScrewFeeder());
        this.loadScrewView.setUseForce(this.data.useForce());
        this.loadScrewView.setApproachEnabled(this.data.approachEnabled());
        this.loadScrewView.setDepartEnabled(this.data.departEnabled());
    }

    public void closeView() {
    }

    public String getTitle() {
        return MultiInstall.prefix() + this.textResource.load(LoadScrewText.LOAD_SCREW);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    void selectScrewFeeder(@NotNull ScrewFeeder screwFeeder) {
        this.data.setSelectedScrewFeeder(screwFeeder);
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
        writer.writeChildren();
    }

    public void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    public void setDepartEnabled(boolean enabled) {
        this.data.setDepartEnabled(enabled);
    }

    public void setUseForce(boolean selected) {
        this.data.setUseForce(selected);
    }

    @NotNull
    private static Expression createExpression(ExpressionBuilder expressionBuilder) {
        try {
            expressionBuilder.append("pose_trans(load_pose, p[0,0,-0.05,0,0,0])");
            return expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Expression createSafeExpression(ExpressionBuilder expressionBuilder) {
        try {
            expressionBuilder.append("pose_trans(load_pose, p[0,0,-0.006,0,0,0])");
            return expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Expression create0expression(ExpressionBuilder expressionBuilder) {
        try {
            expressionBuilder.append("0.0");
            return expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }
}

