/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import com.spin.util.api.ExtendedInstallationAPIProvider;
import com.spin.util.math.PoseMath;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ScrewFeeder {
    @NotNull
    private final UUID id;
    @NotNull
    private final String name;
    @NotNull
    private final Pose pickUpPose;
    @NotNull
    private final JointPositions pickUpJointPositions;
    @NotNull
    private final Length screwLength;
    @NotNull
    private final PoseFactory poseFactory;
    @NotNull
    private final PoseMath.Transformation transformationFromReferenceFrameToBaseFrame;

    public ScrewFeeder(@NotNull UUID id, @NotNull String name, @NotNull Pose pickUpPose, @NotNull JointPositions pickUpJointPositions, @NotNull Length screwLength, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.id = id;
        this.name = name;
        this.pickUpPose = pickUpPose;
        this.pickUpJointPositions = pickUpJointPositions;
        this.screwLength = screwLength;
        this.poseFactory = apiProvider.getInstallationAPIProvider().getInstallationAPI().getValueFactoryProvider().getPoseFactory();
        this.transformationFromReferenceFrameToBaseFrame = apiProvider.getPoseMath().makeTransformationToBaseFrame(pickUpPose);
        assert (screwLength.getAs(Length.Unit.MM) >= 0.0);
    }

    @NotNull
    public UUID id() {
        return this.id;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public Pose pickUpPose() {
        return this.pickUpPose;
    }

    @NotNull
    public Pose abovePickUpPose() {
        Pose relativePose = this.poseFactory.createPose(0.0, 0.0, -60.0, 0.0, 0.0, 0.0, Length.Unit.MM, Angle.Unit.DEG);
        return this.transformationFromReferenceFrameToBaseFrame.applyTo(relativePose);
    }

    @NotNull
    public JointPositions pickUpJointPositions() {
        return this.pickUpJointPositions;
    }

    @NotNull
    public Length screwLength() {
        return this.screwLength;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ScrewFeeder)) {
            return false;
        }
        return ((ScrewFeeder)o).id.equals(this.id);
    }
}

