/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw.pick_screw;

import com.spin.core.program_node.load_screw.pick_screw.PickScrewData;
import com.spin.core.program_node.load_screw.pick_screw.PickScrewText;
import com.spin.core.program_node.load_screw.pick_screw.PickScrewView;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidationFactory;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PickScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final PickScrewView view;
    @NotNull
    private final PickScrewData data;
    @NotNull
    private final ExtendedProgramAPIProvider apiProvider;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UserInteraction userInteraction;

    PickScrewContribution(@NotNull PickScrewView view, @NotNull PickScrewData data, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.apiProvider = apiProvider;
        this.textResource = this.apiProvider.getTextResource();
        this.userInteraction = this.apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
    }

    public void openView() {
        this.view.setMotorSpeedField(this.data.motorSpeedRPM());
        this.view.setRobotSpeedField(this.data.robotSpeedmms());
        this.view.setWaitTimeField(this.data.waitTimesec());
    }

    public void closeView() {
    }

    public String getTitle() {
        return MultiInstall.prefix() + this.textResource.load(PickScrewText.TITlE);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    @NotNull
    private static InputStream loadScrewScript() {
        return Objects.requireNonNull(PickScrewContribution.class.getResourceAsStream("load_screw.script"));
    }

    public void generateScript(ScriptWriter scriptWriter) {
        ScriptParser parser = new ScriptParser(scriptWriter);
        parser.parseToScript(PickScrewContribution.loadScrewScript(), Integer.toString(this.data.motorSpeedRPM()), Integer.toString(this.data.robotSpeedmms()), Double.toString(this.data.waitTimesec()));
    }

    int getMotorSpeedRPM() {
        return this.data.motorSpeedRPM();
    }

    void setMotorSpeedRPM(int motorSpeedRPM) {
        this.data.setMotorSpeedRPM(motorSpeedRPM);
    }

    int getRobotSpeedmms() {
        return this.data.robotSpeedmms();
    }

    void setRobotSpeedmms(int robotSpeedmms) {
        this.data.setRobotSpeedmms(robotSpeedmms);
    }

    double getWaitTimesec() {
        return this.data.waitTimesec();
    }

    void setWaitTimesec(double waitTimesec) {
        this.data.setWaitTimesec(waitTimesec);
    }

    KeyboardNumberInput<Integer> getMotorSpeedIntergerKeypad(@Nullable Integer initialSpeed) {
        KeyboardInputFactory keyboardInputFactory = this.userInteraction.getKeyboardInputFactory();
        InputValidationFactory validationFactory = this.userInteraction.getInputValidationFactory();
        InputValidator validator = validationFactory.createIntegerRangeValidator(this.data.minAllowedRPM().intValue(), this.data.maxAllowedRPM().intValue());
        KeyboardNumberInput keyboard = keyboardInputFactory.createIntegerKeypadInput();
        keyboard.setInitialValue((Object)initialSpeed);
        keyboard.setErrorValidator(validator);
        return keyboard;
    }

    KeyboardNumberInput<Integer> getRobotSpeedIntergerKeypad(@Nullable Integer initialSpeed) {
        KeyboardInputFactory keyboardInputFactory = this.userInteraction.getKeyboardInputFactory();
        KeyboardNumberInput keyboard = keyboardInputFactory.createIntegerKeypadInput();
        keyboard.setInitialValue((Object)initialSpeed);
        return keyboard;
    }

    KeyboardNumberInput<Double> getWaitTimeDoubleKeypad(@Nullable Double initialWait) {
        KeyboardInputFactory keyboardInputFactory = this.userInteraction.getKeyboardInputFactory();
        KeyboardNumberInput keyboard = keyboardInputFactory.createDoubleKeypadInput();
        keyboard.setInitialValue((Object)initialWait);
        return keyboard;
    }
}

