/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar;

import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.bridge_communication.proxy.ToolController;
import com.spin.bridge_communication.result.ResultProvider;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusListener;
import com.spin.bridge_communication.tool_connection.ToolConnectionStatusProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.toolbar.ToolbarView;
import com.spin.domain.BridgeInfo;
import com.spin.domain.RPM;
import com.spin.domain.ToolInfo;
import com.spin.util.api.ExtendedToolbarContext;
import com.spin.util.stream.OptionalUtil;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarContribution;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ToolbarContribution
implements SwingToolbarContribution {
    @NotNull
    private final ToolbarView view;
    @NotNull
    private final ToolController toolController;
    @NotNull
    private final BridgeConnectionStatusProvider bridgeConnectionStatusProvider;
    @NotNull
    private final ToolConnectionStatusProvider toolConnectionStatusProvider;
    @NotNull
    private final ResultProvider resultProvider;

    ToolbarContribution(@NotNull ExtendedToolbarContext context) {
        this.view = new ToolbarView(context, this);
        InstallationContribution installationNode = (InstallationContribution)context.getToolbarContext().getAPIProvider().getApplicationAPI().getInstallationNode(InstallationContribution.class);
        this.toolController = installationNode.getToolController();
        this.bridgeConnectionStatusProvider = installationNode.getBridgeConnectionStatusProvider();
        this.toolConnectionStatusProvider = installationNode.getToolConnectionStatusProvider();
        this.resultProvider = installationNode.getResultProvider();
    }

    public void openView() {
    }

    public void closeView() {
    }

    public void buildUI(@NotNull JPanel panel) {
        this.view.buildUI(panel);
        this.initializeConnectionStatus();
        this.registerBridgeDataListeners();
    }

    private void initializeConnectionStatus() {
        OptionalUtil.ifPresentOrElse(this.bridgeConnectionStatusProvider.getInfo(), this.view::setBridgeConnected, this.view::setBridgeDisconnected);
        OptionalUtil.ifPresentOrElse(this.toolConnectionStatusProvider.getInfo(), this.view::setToolConnected, this.view::setToolDisconnected);
    }

    private void registerBridgeDataListeners() {
        this.bridgeConnectionStatusProvider.registerListener(new BridgeConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull BridgeInfo info) {
                ToolbarContribution.this.view.setBridgeConnected(info);
            }

            @Override
            public void onDisconnected() {
                ToolbarContribution.this.view.setBridgeDisconnected();
            }
        });
        this.toolConnectionStatusProvider.registerListener(new ToolConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull ToolInfo info) {
                ToolbarContribution.this.view.setToolConnected(info);
            }

            @Override
            public void onDisconnected() {
                ToolbarContribution.this.view.setToolDisconnected();
            }
        });
        this.resultProvider.registerConsumer(this.view::addResult);
    }

    boolean startMotor(@NotNull RPM speed) {
        return this.toolController.startMotor(speed);
    }

    boolean stopMotor() {
        return this.toolController.stopMotor();
    }

    void lockBit() {
        this.toolController.lockBit();
    }

    void releaseBit() {
        this.toolController.releaseBit();
    }

    void doSafetyShieldHoming() {
        this.toolController.doSafetyShieldHoming();
    }

    void acknowledgeErrors() {
        this.toolController.acknowledgeErrors();
    }
}

