/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw;

import com.spin.core.installation_node.InstallationContribution;
import com.spin.domain.ScrewFeeder;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.urcap.api.domain.variable.VariableModel;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadScrewData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final InstallationContribution installationContribution;
    @NotNull
    private final VariableModel variableModel;
    private final String aboveFeederVarName = "above_feeder_p";

    LoadScrewData(@NotNull DataModel dataModel, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
        this.variableModel = apiProvider.getProgramAPIProvider().getProgramAPI().getVariableModel();
    }

    boolean isValidConfiguration() {
        return this.selectedScrewFeeder() != null;
    }

    @Nullable
    private UUID selectedScrewFeederId() {
        String selectedScrewFeederId = this.dataModel.get("screwFeeder", (String)null);
        if (selectedScrewFeederId != null) {
            return UUID.fromString(selectedScrewFeederId);
        }
        return null;
    }

    @Nullable
    ScrewFeeder selectedScrewFeeder() {
        UUID selectedScrewFeederId = this.selectedScrewFeederId();
        Set<ScrewFeeder> feeders = this.installationContribution.getScrewFeeders();
        return feeders.stream().filter(feeder -> feeder.id().equals(selectedScrewFeederId)).findFirst().orElse(null);
    }

    void setSelectedScrewFeeder(@NotNull ScrewFeeder screwFeeder) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("screwFeeder", screwFeeder.id().toString()));
    }

    boolean approachEnabled() {
        return this.dataModel.get("approachEnabled", true);
    }

    void setApproachEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("approachEnabled", enabled));
    }

    boolean departEnabled() {
        return this.dataModel.get("departEnabled", true);
    }

    void setDepartEnabled(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("departEnabled", enabled));
    }

    boolean useForce() {
        return this.dataModel.get("useForce", false);
    }

    void setUseForce(boolean enabled) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("useForce", enabled));
    }

    @NotNull
    Variable aboveFeederVar() {
        return this.findExistingAboveFeederVar().orElseGet(this::createAboveFeederVariable);
    }

    @NotNull
    Optional<Variable> findExistingAboveFeederVar() {
        return this.variableModel.get(variable -> variable.getDisplayName().equals("above_feeder_p")).stream().findFirst();
    }

    @NotNull
    private Variable createAboveFeederVariable() {
        try {
            return this.variableModel.getVariableFactory().createGlobalVariable("above_feeder_p");
        }
        catch (VariableException e) {
            SpinLog.print("Unable to create above_feeder_p");
            throw new RuntimeException(e);
        }
    }
}

