/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.keypad;

import com.spin.ui.component.keypad.UnitInputValidator;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import org.jetbrains.annotations.NotNull;

class WrappedUnitValidator<Number, Unit>
implements InputValidator<Number> {
    @NotNull
    private final UnitInputValidator<Unit> unitInputValidator;
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final Class<Unit> unitClass;

    public WrappedUnitValidator(@NotNull UnitInputValidator<Unit> unitInputValidator, @NotNull UnitConverter unitConverter, @NotNull Class<Unit> unitClass) {
        this.unitInputValidator = unitInputValidator;
        this.unitConverter = unitConverter;
        this.unitClass = unitClass;
    }

    public boolean isValid(Number value) {
        Unit unitValue = this.unitConverter.asType(this.unitClass, this.asDouble(value));
        return this.unitInputValidator.isValid(unitValue);
    }

    public String getMessage(Number value) {
        Unit unitValue = this.unitConverter.asType(this.unitClass, this.asDouble(value));
        return this.unitInputValidator.getMessage(unitValue);
    }

    private double asDouble(Number value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new IllegalStateException("Unknown number type");
    }
}

