/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.safe_approach;

import com.spin.core.program_node.safe_approach.SafeApproachText;
import com.spin.util.i18n.TextResource;
import com.spin.util.logging.SpinLog;
import com.spin.util.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SafeApproachScriptGenerator {
    @NotNull
    private final TextResource textResource;

    public SafeApproachScriptGenerator(@NotNull TextResource textResource) {
        this.textResource = textResource;
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(SafeApproachScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    public void generateScript(ScriptWriter writer) {
        SpinLog.print("SafeApproachScriptGenerator.generateScript");
        ScriptParser parser = new ScriptParser(writer);
        String errorTitle = this.textResource.load(SafeApproachText.ERROR_TITLE);
        String errorMessage = this.textResource.load(SafeApproachText.ERROR_APPROACH_FAILED);
        parser.parseToScript(SafeApproachScriptGenerator.safeApproachScript(), errorMessage, errorTitle);
    }
}

