/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.attach_bit;

import com.spin.core.program_node.attach_bit.AttachBitData;
import com.spin.core.program_node.attach_bit.AttachBitText;
import com.spin.domain.BitChangingStation;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AttachBitScriptGenerator {
    @NotNull
    private static InputStream variableDeclarationsScript() {
        return Objects.requireNonNull(AttachBitScriptGenerator.class.getResourceAsStream("variable_declarations.script"));
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(AttachBitScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    @NotNull
    private static InputStream directApproachScript() {
        return Objects.requireNonNull(AttachBitScriptGenerator.class.getResourceAsStream("direct_approach.script"));
    }

    @NotNull
    private static InputStream attachBitScript() {
        return Objects.requireNonNull(AttachBitScriptGenerator.class.getResourceAsStream("attach_bit.script"));
    }

    @NotNull
    private static InputStream departScript() {
        return Objects.requireNonNull(AttachBitScriptGenerator.class.getResourceAsStream("depart.script"));
    }

    void generateScript(@NotNull ScriptWriter writer, @NotNull TextResource textResource, @NotNull AttachBitData data) {
        BitChangingStation.Bit bit = Objects.requireNonNull(data.selectedBit());
        BitChangingStation station = Objects.requireNonNull(data.selectedStation());
        Pose bitPose = station.poseOf(bit);
        Pose poseInFront = station.poseInFrontOf(bit);
        String errorMessage = ScriptUtil.wrapInQuotes(textResource.load(AttachBitText.ERROR_MESSAGE));
        String errorTitle = ScriptUtil.wrapInQuotes(textResource.load(AttachBitText.ERROR_TITLE));
        ScriptParser parser = new ScriptParser(writer);
        parser.parseToScript(AttachBitScriptGenerator.variableDeclarationsScript(), ScriptUtil.toScript(bitPose), ScriptUtil.toScript(poseInFront), errorMessage, errorTitle);
        parser.parseToScript(data.approachEnabled() ? AttachBitScriptGenerator.safeApproachScript() : AttachBitScriptGenerator.directApproachScript(), new String[0]);
        parser.parseToScript(AttachBitScriptGenerator.attachBitScript(), new String[0]);
        if (data.departEnabled()) {
            parser.parseToScript(AttachBitScriptGenerator.departScript(), new String[0]);
        }
    }
}

