/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.image;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

class IconLoader {
    IconLoader() {
    }

    @NotNull
    static ImageIcon load(@NotNull String fileName) {
        Image image = IconLoader.loadImage(fileName);
        return new ImageIcon(image);
    }

    @NotNull
    static ImageIcon load(@NotNull String fileName, @NotNull Dimension dimension) {
        Image image = IconLoader.loadImage(fileName);
        Image scaledImage = image.getScaledInstance(dimension.width, dimension.height, 1);
        return new ImageIcon(scaledImage);
    }

    @NotNull
    private static Image loadImage(@NotNull String fileName) {
        URL url = IconLoader.getResourceURL(fileName);
        return IconLoader.loadFromURL(url);
    }

    @NotNull
    private static URL getResourceURL(@NotNull String fileName) {
        URL url = IconLoader.class.getResource(fileName);
        if (url == null || fileName.isEmpty()) {
            throw new MissingIconException("No file \"" + fileName + "\" exists in class path of\"" + IconLoader.class.getPackage().getName() + "\"");
        }
        return url;
    }

    @NotNull
    private static Image loadFromURL(@NotNull URL url) {
        try {
            BufferedImage image = ImageIO.read(url);
            if (image == null) {
                throw new MissingIconException("File \"" + url.getFile() + "\" is not a valid image file");
            }
            return image;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class MissingIconException
    extends RuntimeException {
        public MissingIconException(@NotNull String message) {
            super(message);
        }
    }
}

