/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util.script;

import com.spin.domain.MultiInstall;
import com.spin.util.script.ScriptParsingFailed;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ScriptParser {
    @NotNull
    private final ScriptWriter writer;

    public ScriptParser(@NotNull ScriptWriter writer) {
        this.writer = writer;
    }

    @NotNull
    private static ArrayList<String> asArrayList(@NotNull String[] strings) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, strings);
        return list;
    }

    @NotNull
    private static BufferedReader getReader(@NotNull InputStream scriptStream) {
        InputStreamReader inStream = new InputStreamReader(scriptStream);
        return new BufferedReader(inStream);
    }

    @NotNull
    private static String populatePlaceholders(@NotNull String line, @NotNull ArrayList<String> replacementStrings) {
        while (line.contains("%s")) {
            line = line.replaceFirst("%s", ScriptParser.popFirst(replacementStrings));
        }
        return line;
    }

    @NotNull
    private static String populateMultiinstallPrefixPlaceholders(@NotNull String line, @NotNull String prefix) {
        line = line.replaceAll("spin_", prefix);
        return line;
    }

    @NotNull
    private static String popFirst(@NotNull ArrayList<String> replacementStrings) {
        if (replacementStrings.isEmpty()) {
            throw new ScriptParsingFailed("Script has too many placeholders");
        }
        return replacementStrings.remove(0);
    }

    private static void parseAndWriteScriptLines(@NotNull ScriptWriter writer, @NotNull BufferedReader reader, @NotNull ArrayList<String> replacementStrings) {
        try {
            String line = reader.readLine();
            while (line != null) {
                line = ScriptParser.populateMultiinstallPrefixPlaceholders(line, MultiInstall.urscriptPrefix());
                writer.appendLine(ScriptParser.populatePlaceholders(line, replacementStrings));
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void parseToScript(@NotNull InputStream scriptStream, String ... stringsToInsert) {
        ArrayList<String> replacementStrings = ScriptParser.asArrayList(stringsToInsert);
        BufferedReader reader = ScriptParser.getReader(scriptStream);
        ScriptParser.parseAndWriteScriptLines(this.writer, reader, replacementStrings);
        if (!replacementStrings.isEmpty()) {
            throw new ScriptParsingFailed("Script has too few placeholders");
        }
    }
}

