/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_OK;

import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayInterface;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayService;
import com.spin.core.program_node.screwdriving_setup.on_OK.OnOkText;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

public class OnOkContribution
implements ProgramNodeContribution {
    @NotNull
    private final String nodeTitle;

    OnOkContribution(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType nodeCreationType) {
        this.nodeTitle = apiProvider.getTextResource().load(OnOkText.ON_OK);
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            OnOkContribution.buildSubTree(apiProvider, this);
        }
    }

    private static void addMoveAwayNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull SimpleValueFactory valueFactory) throws TreeStructureException {
        URCapProgramNode moveNode = programNodeFactory.createURCapProgramNode(MoveAwayService.class);
        rootNode.addChild((ProgramNode)moveNode);
        ((MoveAwayInterface)moveNode.getAs(MoveAwayInterface.class)).setMoveDistance(valueFactory.createLength(50.0, Length.Unit.MM));
    }

    private static void addSafetyShieldCoverBitNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        URCapProgramNode toolActionNode = programNodeFactory.createURCapProgramNode(ToolActionService.class);
        rootNode.addChild((ProgramNode)toolActionNode);
        ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
    }

    private static void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull OnOkContribution contribution) {
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        ProgramNodeFactory programNodeFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        SimpleValueFactory valueFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        try {
            OnOkContribution.addMoveAwayNode(rootNode, programNodeFactory, valueFactory);
            OnOkContribution.addSafetyShieldCoverBitNode(rootNode, programNodeFactory);
        }
        catch (TreeStructureException e) {
            SpinLog.print("Cannot add child nodes to onSuccess node: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        writer.appendLine("if (" + MultiInstall.urscriptPrefix() + "result_evaluation == 2):");
        writer.appendLine("  sync()");
        writer.writeChildren();
    }
}

