/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.unload_screw;

import com.spin.core.program_node.unload_screw.UnloadScrewData;
import com.spin.domain.ScrewFeeder;
import com.spin.i18n.TextResource;
import com.spin.script.ScriptParser;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UnloadScrewScriptGenerator {
    void generateScript(@NotNull ScriptWriter scriptWriter, TextResource textResource, UnloadScrewData data) {
        ScrewFeeder feeder = data.selectedScrewFeeder();
        Length screwLength = feeder.screwLength();
        Pose unloadPose = data.getPose();
        InputStream unloadScrewScript = Objects.requireNonNull(this.getClass().getResourceAsStream("UnloadScrew.script"));
        ScriptParser parser = new ScriptParser(scriptWriter);
        parser.parseToScript(unloadScrewScript, this.poseToScriptString(unloadPose), Double.toString(screwLength.getAs(Length.Unit.M)), this.boolToString(data.approachEnabled()), this.boolToString(data.departEnabled()), "\"test_msg\"", "\"test_title\"");
    }

    private String poseToScriptString(Pose pose) {
        double[] values = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        assert (values.length == 6);
        return String.format("p[%f, %f, %f, %f, %f, %f]", values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    private String boolToString(Boolean bool) {
        return bool != false ? "True" : "False";
    }
}

