/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.screw_feeder;

import com.spin.api.ExtendedInstallationAPIProvider;
import com.spin.domain.ScrewFeeder;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.ValueFactoryProvider;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ScrewFeederData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final ValueFactoryProvider valueFactoryProvider;

    public ScrewFeederData(@NotNull DataModel dataModel, @NotNull ExtendedInstallationAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.valueFactoryProvider = apiProvider.getInstallationAPIProvider().getInstallationAPI().getValueFactoryProvider();
    }

    @NotNull
    Length minAllowedScrewLength() {
        return this.valueFactoryProvider.getSimpleValueFactory().createLength(0.0, Length.Unit.MM);
    }

    @NotNull
    Length maxAllowedScrewLength() {
        return this.valueFactoryProvider.getSimpleValueFactory().createLength(56.0, Length.Unit.MM);
    }

    @NotNull
    Pose calculateAboveScrewPose(@NotNull Pose screwPose) {
        double[] p = screwPose.toArray(Length.Unit.MM, Angle.Unit.DEG);
        p[2] = p[2] + 60.0;
        return this.valueFactoryProvider.getPoseFactory().createPose(p[0], p[1], p[2], p[3], p[4], p[5], Length.Unit.MM, Angle.Unit.DEG);
    }

    @NotNull
    Set<ScrewFeeder> screwFeeders() {
        return this.loadAllIDs().stream().map(this::loadFeederByID).collect(Collectors.toSet());
    }

    void storeScrewFeeder(@NotNull ScrewFeeder feeder) {
        this.storeID(feeder.id());
        this.storeFeeder(feeder);
    }

    void removeScrewFeeder(@NotNull ScrewFeeder feeder) {
        this.removeID(feeder.id());
        this.removeFeeder(feeder);
    }

    @NotNull
    private Collection<String> loadAllIDs() {
        String[] idLists = this.dataModel.get("id_list", new String[0]);
        return Arrays.asList(idLists);
    }

    private void storeID(@NotNull UUID id) {
        HashSet<String> ids = new HashSet<String>(this.loadAllIDs());
        ids.add(id.toString());
        this.dataModel.set("id_list", ids.toArray(new String[0]));
    }

    private void removeID(@NotNull UUID id) {
        HashSet<String> ids = new HashSet<String>(this.loadAllIDs());
        ids.remove(id.toString());
        this.dataModel.set("id_list", ids.toArray(new String[0]));
    }

    private void storeFeeder(@NotNull ScrewFeeder feeder) {
        String id = feeder.id().toString();
        this.dataModel.set("id" + id, feeder.id().toString());
        this.dataModel.set("name" + id, feeder.name());
        this.dataModel.set("pose" + id, feeder.pickUpPose());
        this.dataModel.set("joint_pos" + id, feeder.pickUpJointPositions());
        this.dataModel.set("screw_length" + id, feeder.screwLength());
    }

    private void removeFeeder(@NotNull ScrewFeeder feeder) {
        String id = feeder.id().toString();
        this.dataModel.remove("id" + id);
        this.dataModel.remove("name" + id);
        this.dataModel.remove("pose" + id);
        this.dataModel.remove("joint_pos" + id);
        this.dataModel.remove("screw_length" + id);
        this.dataModel.remove("attempts" + id);
    }

    @NotNull
    private ScrewFeeder loadFeederByID(@NotNull String id) {
        String feederID = this.dataModel.get("id" + id, (String)null);
        String name = this.dataModel.get("name" + id, (String)null);
        Pose pickUpPose = this.dataModel.get("pose" + id, (Pose)null);
        JointPositions pickUpJointPositions = this.dataModel.get("joint_pos" + id, (JointPositions)null);
        Length screwLength = this.dataModel.get("screw_length" + id, (Length)null);
        assert (Stream.of(feederID, name, pickUpPose, pickUpJointPositions, screwLength).noneMatch(Objects::isNull));
        return new ScrewFeeder(UUID.fromString(id), name, pickUpPose, pickUpJointPositions, screwLength);
    }
}

